/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.processor.loadbalancer.DistributionRatio;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;

public abstract class WeightedLoadBalancer
extends QueueLoadBalancer {
    protected final List<DistributionRatio> ratios;
    protected final int distributionRatioSum;
    protected int runtimeRatioSum;
    transient int lastIndex = -1;

    public WeightedLoadBalancer(List<Integer> distributionRatios) {
        List ratios = distributionRatios.stream().map(DistributionRatio::new).collect(Collectors.toList());
        this.ratios = Collections.unmodifiableList(ratios);
        this.runtimeRatioSum = this.distributionRatioSum = ratios.stream().mapToInt(DistributionRatio::getDistributionWeight).sum();
    }

    public int getLastChosenProcessorIndex() {
        return this.lastIndex;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.getProcessors().size() != this.ratios.size()) {
            throw new IllegalArgumentException("Loadbalacing with " + this.getProcessors().size() + " should match number of distributions " + this.ratios.size());
        }
    }

    protected void decrementSum() {
        if (--this.runtimeRatioSum == 0) {
            this.reset();
        }
    }

    protected void reset() {
        for (DistributionRatio ratio : this.ratios) {
            ratio.reset();
        }
        this.runtimeRatioSum = this.distributionRatioSum;
    }

    public List<DistributionRatio> getRatios() {
        return this.ratios;
    }
}

