/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.object.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.openstack4j.api.Apis;
import org.openstack4j.api.storage.ObjectStorageObjectService;
import org.openstack4j.model.common.DLPayload;
import org.openstack4j.model.storage.block.options.DownloadOptions;
import org.openstack4j.model.storage.object.SwiftObject;

public class SwiftObjectImpl
implements SwiftObject {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="hash")
    private String eTag;
    @JsonProperty(value="last_modified")
    private Date lastModified;
    @JsonProperty(value="bytes")
    private long sizeBytes;
    @JsonProperty
    private String name;
    @JsonProperty(value="subdir")
    private String directoryName;
    @JsonProperty(value="content_type")
    private String mimeType;
    @JsonIgnore
    private Map<String, String> metadata;
    @JsonIgnore
    private String containerName;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeBytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDirectoryName() {
        return this.directoryName;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public boolean isDirectory() {
        if (this.directoryName != null && this.mimeType == null) {
            return true;
        }
        return "application/directory".equals(this.mimeType);
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    @Override
    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            this.metadata = Apis.get(ObjectStorageObjectService.class).getMetadata(this.containerName, this.name);
        }
        return this.metadata;
    }

    @Override
    public DLPayload download() {
        return this.download(DownloadOptions.create());
    }

    @Override
    public DLPayload download(DownloadOptions options) {
        return Apis.get(ObjectStorageObjectService.class).download(this.containerName, this.name, options);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("last_modified", (Object)this.lastModified).add("mimeType", (Object)this.mimeType).add("size_bytes", this.sizeBytes).add("ETag", (Object)this.eTag).add("directory", this.isDirectory()).add("containerName", (Object)this.containerName).add("metadata", this.metadata).toString();
    }

    public static class Builder {
        private SwiftObjectImpl obj = new SwiftObjectImpl();

        public Builder name(String name) {
            this.obj.name = name;
            return this;
        }

        public Builder directoryName(String directoryName) {
            this.obj.directoryName = directoryName;
            return this;
        }

        public Builder eTag(String eTag) {
            this.obj.eTag = eTag;
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.obj.lastModified = lastModified;
            return this;
        }

        public Builder sizeBytes(long sizeBytes) {
            this.obj.sizeBytes = sizeBytes;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.obj.mimeType = mimeType;
            return this;
        }

        public Builder containerName(String containerName) {
            this.obj.containerName = containerName;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.obj.metadata = metadata;
            return this;
        }

        public SwiftObjectImpl build() {
            return this.obj;
        }
    }

    public static class SwiftObjects
    extends ArrayList<SwiftObjectImpl> {
        private static final long serialVersionUID = 1L;
    }
}

