/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.PortService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.builder.PortBuilder;
import org.openstack4j.model.network.options.PortListOptions;
import org.openstack4j.openstack.networking.domain.NeutronPort;
import org.openstack4j.openstack.networking.domain.NeutronPortCreate;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class PortServiceImpl
extends BaseNetworkingServices
implements PortService {
    @Override
    public List<? extends Port> list() {
        return this.get(NeutronPort.Ports.class, this.uri("/ports", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Port> list(PortListOptions options) {
        if (options == null) {
            return this.list();
        }
        return this.get(NeutronPort.Ports.class, this.uri("/ports", new Object[0])).params(options.getOptions()).execute().getList();
    }

    @Override
    public Port get(String portId) {
        Preconditions.checkNotNull((Object)portId);
        return this.get(NeutronPort.class, this.uri("/ports/%s", portId)).execute();
    }

    @Override
    public ActionResponse delete(String portId) {
        Preconditions.checkNotNull((Object)portId);
        return this.deleteWithResponse(this.uri("/ports/%s", portId)).execute();
    }

    @Override
    public Port create(Port port) {
        Preconditions.checkNotNull((Object)port);
        Preconditions.checkNotNull((Object)port.getNetworkId(), (Object)"NetworkId is a required field");
        return this.post(NeutronPort.class, this.uri("/ports", new Object[0])).entity(NeutronPortCreate.fromPort(port)).execute();
    }

    @Override
    public Port update(Port port) {
        Preconditions.checkNotNull((Object)port);
        Preconditions.checkNotNull((Object)port.getId());
        Port p = (Port)((PortBuilder)port.toBuilder()).networkId(null).state(null).tenantId(null).macAddress(null).build();
        return this.put(NeutronPort.class, this.uri("/ports/%s", this.getAndClearIdentifier(p))).entity(p).execute();
    }

    private String getAndClearIdentifier(Port port) {
        String portId = port.getId();
        port.setId(null);
        return portId;
    }
}

