/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.api.Apis;
import org.openstack4j.model.identity.v2.Tenant;
import org.openstack4j.model.identity.v2.builder.TenantBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="tenant")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneTenant
implements Tenant {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private Boolean enabled = true;

    public static TenantBuilder builder() {
        return new TenantConcreteBuilder();
    }

    @Override
    public TenantBuilder toBuilder() {
        return new TenantConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void delete() {
        if (this.id != null) {
            Apis.getIdentityV2Services().tenants().delete(this.getId());
        }
    }

    @Override
    public void update() {
        if (this.id != null) {
            Apis.getIdentityV2Services().tenants().update(this);
        }
    }

    @Override
    public void addUser(String userId, String roleId) {
        Apis.getIdentityV2Services().roles().addUserRole(this.id, userId, roleId);
    }

    @Override
    public void removeUser(String userId, String roleId) {
        Apis.getIdentityV2Services().roles().removeUserRole(this.id, userId, roleId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.description});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneTenant that = (KeystoneTenant)KeystoneTenant.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.description, (Object)that.description);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("enabled", (Object)this.enabled).toString();
    }

    public static class BackwardsCompatTenants
    extends Tenants {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="tenant")
        private KeystoneTenant tenant;

        public KeystoneTenant getOneOrNull() {
            if (this.tenant != null) {
                return this.tenant;
            }
            return this.list != null && this.list.size() > 0 ? (KeystoneTenant)this.list.get(0) : null;
        }
    }

    public static class Tenants
    extends ListResult<KeystoneTenant> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="tenants")
        protected List<KeystoneTenant> list;

        @Override
        public List<KeystoneTenant> value() {
            return this.list;
        }
    }

    public static class TenantConcreteBuilder
    implements TenantBuilder {
        KeystoneTenant model;

        TenantConcreteBuilder() {
            this(new KeystoneTenant());
        }

        TenantConcreteBuilder(KeystoneTenant model) {
            this.model = model;
        }

        @Override
        public TenantBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public TenantBuilder description(String desc) {
            this.model.description = desc;
            return this;
        }

        @Override
        public TenantBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public TenantBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public Tenant build() {
            return this.model;
        }

        @Override
        public TenantBuilder from(Tenant in) {
            if (in != null) {
                this.model = (KeystoneTenant)in;
            }
            return this;
        }
    }
}

