/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.api;

import java.util.ServiceLoader;
import org.openstack4j.api.APIProvider;
import org.openstack4j.api.compute.ComputeService;
import org.openstack4j.api.gbp.GbpService;
import org.openstack4j.api.heat.HeatService;
import org.openstack4j.api.identity.v2.IdentityService;
import org.openstack4j.api.image.ImageService;
import org.openstack4j.api.manila.ShareService;
import org.openstack4j.api.networking.NetworkingService;
import org.openstack4j.api.sahara.SaharaService;
import org.openstack4j.api.senlin.SenlinService;

public class Apis {
    private static final APIProvider provider = Apis.initializeProvider();

    public static <T> T get(Class<T> api) {
        return provider.get(api);
    }

    public static org.openstack4j.api.identity.v3.IdentityService getIdentityV3Services() {
        return Apis.get(org.openstack4j.api.identity.v3.IdentityService.class);
    }

    public static IdentityService getIdentityV2Services() {
        return Apis.get(IdentityService.class);
    }

    public static ComputeService getComputeServices() {
        return Apis.get(ComputeService.class);
    }

    public static NetworkingService getNetworkingServices() {
        return Apis.get(NetworkingService.class);
    }

    public static ImageService getImageService() {
        return Apis.get(ImageService.class);
    }

    public static HeatService getHeatServices() {
        return Apis.get(HeatService.class);
    }

    public static SaharaService getSaharaServices() {
        return Apis.get(SaharaService.class);
    }

    public static ShareService getShareServices() {
        return Apis.get(ShareService.class);
    }

    public static GbpService getGbpServices() {
        return Apis.get(GbpService.class);
    }

    public static SenlinService getSenlinServices() {
        return Apis.get(SenlinService.class);
    }

    private static APIProvider initializeProvider() {
        APIProvider p = ServiceLoader.load(APIProvider.class, Apis.class.getClassLoader()).iterator().next();
        p.initialize();
        return p;
    }
}

