/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.openstack4j.model.compute.Action;
import org.openstack4j.model.compute.RebootType;
import org.openstack4j.openstack.compute.domain.actions.ServerAction;
import org.slf4j.LoggerFactory;

public final class BasicActions {
    public static ServerAction actionInstanceFor(Action action) {
        switch (action) {
            case PAUSE: {
                return BasicActions.instanceFor(Pause.class);
            }
            case UNPAUSE: {
                return BasicActions.instanceFor(UnPause.class);
            }
            case LOCK: {
                return BasicActions.instanceFor(Lock.class);
            }
            case UNLOCK: {
                return BasicActions.instanceFor(UnLock.class);
            }
            case START: {
                return BasicActions.instanceFor(Start.class);
            }
            case STOP: {
                return BasicActions.instanceFor(Stop.class);
            }
            case RESUME: {
                return BasicActions.instanceFor(Resume.class);
            }
            case RESCUE: {
                return BasicActions.instanceFor(Rescue.class);
            }
            case UNRESCUE: {
                return BasicActions.instanceFor(UnRescue.class);
            }
            case SHELVE: {
                return BasicActions.instanceFor(Shelve.class);
            }
            case SHELVE_OFFLOAD: {
                return BasicActions.instanceFor(ShelveOffload.class);
            }
            case UNSHELVE: {
                return BasicActions.instanceFor(UnShelve.class);
            }
            case SUSPEND: {
                return BasicActions.instanceFor(Suspend.class);
            }
        }
        return null;
    }

    public static ServerAction instanceFor(Class<? extends ServerAction> action) {
        ServerAction sa = null;
        try {
            sa = action.newInstance();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(ServerAction.class).error(t.getMessage(), t);
        }
        return sa;
    }

    @JsonRootName(value="changePassword")
    public static class ChangePassword
    implements ServerAction {
        @JsonProperty(value="adminPass")
        public String adminPass;

        public ChangePassword(String adminPass) {
            this.adminPass = adminPass;
        }
    }

    @JsonRootName(value="resize")
    public static class Resize
    implements ServerAction {
        @JsonProperty(value="flavorRef")
        public String flavorRef;

        public Resize(String flavorRef) {
            this.flavorRef = flavorRef;
        }
    }

    @JsonRootName(value="reboot")
    public static class Reboot
    implements ServerAction {
        @JsonProperty(value="type")
        public String type;

        public Reboot(RebootType type) {
            this.type = type.name();
        }
    }

    @JsonRootName(value="migrate")
    public static class Migrate
    implements ServerAction {
    }

    @JsonRootName(value="revertResize")
    public static class RevertResize
    implements ServerAction {
    }

    @JsonRootName(value="confirmResize")
    public static class ConfirmResize
    implements ServerAction {
    }

    @JsonRootName(value="suspend")
    public static class Suspend
    implements ServerAction {
    }

    @JsonRootName(value="unshelve")
    public static class UnShelve
    implements ServerAction {
    }

    @JsonRootName(value="shelveOffload")
    public static class ShelveOffload
    implements ServerAction {
    }

    @JsonRootName(value="shelve")
    public static class Shelve
    implements ServerAction {
    }

    @JsonRootName(value="unrescue")
    public static class UnRescue
    implements ServerAction {
    }

    @JsonRootName(value="rescue")
    public static class Rescue
    implements ServerAction {
    }

    @JsonRootName(value="resume")
    public static class Resume
    implements ServerAction {
    }

    @JsonRootName(value="os-stop")
    public static class Stop
    implements ServerAction {
    }

    @JsonRootName(value="os-start")
    public static class Start
    implements ServerAction {
    }

    @JsonRootName(value="unlock")
    public static class UnLock
    implements ServerAction {
    }

    @JsonRootName(value="lock")
    public static class Lock
    implements ServerAction {
    }

    @JsonRootName(value="unpause")
    public static class UnPause
    implements ServerAction {
    }

    @JsonRootName(value="pause")
    public static class Pause
    implements ServerAction {
    }
}

