/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.object.functions;

import com.google.common.base.Function;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectLocation;
import org.openstack4j.openstack.internal.Parser;
import org.openstack4j.openstack.storage.object.domain.SwiftObjectImpl;
import org.openstack4j.openstack.storage.object.functions.MapWithoutMetaPrefixFunction;

public class ParseObjectFunction
implements Function<HttpResponse, SwiftObject> {
    private ObjectLocation location;

    private ParseObjectFunction(ObjectLocation location) {
        this.location = location;
    }

    public static ParseObjectFunction create(ObjectLocation location) {
        return new ParseObjectFunction(location);
    }

    public SwiftObject apply(HttpResponse resp) {
        return SwiftObjectImpl.builder().name(this.location.getObjectName()).containerName(this.location.getContainerName()).mimeType(resp.header("Content-Type")).sizeBytes(Parser.asLong(resp.header("Content-Length"))).metadata(MapWithoutMetaPrefixFunction.INSTANCE.apply(resp.headers())).lastModified(Parser.toRFC822DateParse(resp.header("Last-Modified"))).build();
    }
}

