/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.trove.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import org.openstack4j.model.trove.Datastore;
import org.openstack4j.model.trove.InstanceCreate;
import org.openstack4j.model.trove.builder.InstanceCreateBuilder;

@JsonRootName(value="instance")
public class TroveInstanceCreate
implements InstanceCreate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="volume")
    private Volume volume;
    @JsonProperty(value="flavorRef")
    private String flavorRef;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="datastore")
    private Datastore datastore;
    @JsonProperty(value="availability_zone")
    private String availabilityZone;

    public void setVolume(Volume volume) {
        this.volume = volume;
    }

    @Override
    public void setFlavor(String flavorRef) {
        this.flavorRef = flavorRef;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVolumetype(String volumeType) {
        this.volume.setType(volumeType);
    }

    @Override
    public void setvolumeSize(int size) {
        this.volume.setSize(size);
    }

    @Override
    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }

    @Override
    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public static InstanceCreateBuilder builder() {
        return new ConcereteInstanceBuilder();
    }

    @Override
    public InstanceCreateBuilder toBuilder() {
        return new ConcereteInstanceBuilder(this);
    }

    public static class ConcereteInstanceBuilder
    implements InstanceCreateBuilder {
        private TroveInstanceCreate instance;

        public ConcereteInstanceBuilder() {
            this(new TroveInstanceCreate());
        }

        public ConcereteInstanceBuilder(TroveInstanceCreate instance) {
            this.instance = instance;
            this.instance.setVolume(instance.new Volume());
        }

        @Override
        public InstanceCreate build() {
            return this.instance;
        }

        @Override
        public InstanceCreateBuilder from(InstanceCreate in) {
            this.instance = (TroveInstanceCreate)in;
            return this;
        }

        @Override
        public InstanceCreateBuilder flavor(String flavorRef) {
            this.instance.setFlavor(flavorRef);
            return this;
        }

        @Override
        public InstanceCreateBuilder name(String name) {
            this.instance.setName(name);
            return this;
        }

        @Override
        public InstanceCreateBuilder datastore(Datastore datastore) {
            this.instance.setDatastore(datastore);
            return this;
        }

        @Override
        public InstanceCreateBuilder volumeType(String volumeType) {
            this.instance.setVolumetype(volumeType);
            return this;
        }

        @Override
        public InstanceCreateBuilder volumeSize(int size) {
            this.instance.setvolumeSize(size);
            return this;
        }

        @Override
        public InstanceCreateBuilder availabilityZone(String availabilityZone) {
            this.instance.setAvailabilityZone(availabilityZone);
            return this;
        }
    }

    public class Volume {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="size")
        private Integer size;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }
    }
}

