/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstack4j.model.common.builder.ResourceBuilder;
import org.openstack4j.model.network.AllowedAddressPair;
import org.openstack4j.model.network.ExtraDhcpOptCreate;
import org.openstack4j.model.network.IP;
import org.openstack4j.model.network.Port;
import org.openstack4j.model.network.State;
import org.openstack4j.model.network.builder.PortBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.NeutronAllowedAddressPair;
import org.openstack4j.openstack.networking.domain.NeutronExtraDhcpOptCreate;
import org.openstack4j.openstack.networking.domain.NeutronIP;

@JsonRootName(value="port")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronPort
implements Port {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;
    @JsonProperty(value="device_id")
    private String deviceId;
    @JsonProperty(value="device_owner")
    private String deviceOwner;
    @JsonProperty(value="fixed_ips")
    private Set<NeutronIP> fixedIps;
    @JsonProperty(value="allowed_address_pairs")
    private Set<NeutronAllowedAddressPair> allowedAddressPairs;
    @JsonProperty(value="mac_address")
    private String macAddress;
    @JsonProperty(value="network_id")
    private String networkId;
    @JsonProperty(value="status")
    private State state;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="trunkport:type")
    private String trunkPortType;
    @JsonProperty(value="trunkport:parent_id")
    private String trunkPortParentId;
    @JsonProperty(value="trunkport:vid")
    private String trunkPortVlanId;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups;
    @JsonProperty(value="extra_dhcp_opts")
    private List<NeutronExtraDhcpOptCreate> extraDhcpOptCreates;
    @JsonProperty(value="port_security_enabled")
    private Boolean portSecurityEnabled;
    @JsonProperty(value="binding:host_id")
    private String hostId;
    @JsonProperty(value="binding:vif_type")
    private String vifType;
    @JsonProperty(value="binding:vif_details")
    private Map<String, Object> vifDetails;
    @JsonProperty(value="binding:vnic_type")
    private String vNicType;
    @JsonProperty(value="binding:profile")
    private Map<String, Object> profile;

    public static PortBuilder builder() {
        return new PortConcreteBuilder();
    }

    @Override
    public PortBuilder toBuilder() {
        return new PortConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public String getNetworkId() {
        return this.networkId;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getDeviceOwner() {
        return this.deviceOwner;
    }

    @Override
    public Set<? extends IP> getFixedIps() {
        return this.fixedIps;
    }

    @Override
    public Set<? extends AllowedAddressPair> getAllowedAddressPairs() {
        return this.allowedAddressPairs;
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public String getHostId() {
        return this.hostId;
    }

    @Override
    public String getVifType() {
        return this.vifType;
    }

    @Override
    public Map<String, Object> getVifDetails() {
        return this.vifDetails;
    }

    @Override
    public String getvNicType() {
        return this.vNicType;
    }

    @Override
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @Override
    public String getTrunkPortParentId() {
        return this.trunkPortParentId;
    }

    @Override
    public String getTrunkPortType() {
        return this.trunkPortType;
    }

    @Override
    public String getTrunkPortVlanId() {
        return this.trunkPortVlanId;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public void setVifType(String vifType) {
        this.vifType = vifType;
    }

    public void setVifDetails(Map<String, Object> vifDetails) {
        this.vifDetails = vifDetails;
    }

    public void setvNicType(String vNicType) {
        this.vNicType = vNicType;
    }

    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    @Override
    public Boolean isPortSecurityEnabled() {
        return this.portSecurityEnabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("adminStateUp", this.adminStateUp).add("deviceId", (Object)this.deviceId).add("trunkPortType", (Object)this.trunkPortType).add("trunkPortParentId", (Object)this.trunkPortParentId).add("trunkPortVlanId", (Object)this.trunkPortVlanId).add("deviceOwner", (Object)this.deviceOwner).add("fixedIps", this.fixedIps).add("macAddress", (Object)this.macAddress).add("networkId", (Object)this.networkId).add("tenantId", (Object)this.tenantId).add("securityGroups", this.securityGroups).add("allowed_address_pairs", this.allowedAddressPairs).add("port_security_enabled ", (Object)this.portSecurityEnabled).add("binding:host_id", (Object)this.hostId).add("binding:vif_type", (Object)this.vifType).add("binding:vif_details", this.vifDetails).add("binding:vnic_type", (Object)this.vNicType).add("binding:profile", this.profile).toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.adminStateUp, this.deviceId, this.deviceOwner, this.fixedIps, this.macAddress, this.networkId, this.tenantId, this.securityGroups, this.allowedAddressPairs, this.portSecurityEnabled, this.hostId, this.vifType, this.vifDetails, this.vNicType, this.profile);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeutronPort) {
            NeutronPort that = (NeutronPort)obj;
            if (Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.adminStateUp, that.adminStateUp) && Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.deviceOwner, that.deviceOwner) && Objects.equals(this.fixedIps, that.fixedIps) && Objects.equals(this.macAddress, that.macAddress) && Objects.equals(this.networkId, that.networkId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.securityGroups, that.securityGroups) && Objects.equals(this.allowedAddressPairs, that.allowedAddressPairs) && Objects.equals(this.portSecurityEnabled, that.portSecurityEnabled) && Objects.equals(this.hostId, that.hostId) && Objects.equals(this.vifType, that.vifType) && Objects.equals(this.vifDetails, that.vifDetails) && Objects.equals(this.vNicType, that.vNicType) && Objects.equals(this.profile, that.profile)) {
                return true;
            }
        }
        return false;
    }

    public static class PortConcreteBuilder
    extends ResourceBuilder<Port, PortConcreteBuilder>
    implements PortBuilder {
        private NeutronPort m;

        PortConcreteBuilder() {
            this(new NeutronPort());
        }

        PortConcreteBuilder(NeutronPort port) {
            this.m = port;
        }

        @Override
        public PortBuilder networkId(String networkId) {
            this.m.networkId = networkId;
            return this;
        }

        @Override
        public PortBuilder deviceId(String deviceId) {
            this.m.deviceId = deviceId;
            return this;
        }

        @Override
        public PortBuilder deviceOwner(String deviceOwner) {
            this.m.deviceOwner = deviceOwner;
            return this;
        }

        @Override
        public PortBuilder macAddress(String macAddress) {
            this.m.macAddress = macAddress;
            return this;
        }

        @Override
        public PortBuilder fixedIp(String address, String subnetId) {
            if (this.m.fixedIps == null) {
                this.m.fixedIps = Sets.newHashSet();
            }
            this.m.fixedIps.add(new NeutronIP(address, subnetId));
            return this;
        }

        @Override
        public PortBuilder removeFixedIp(String address, String subnetId) {
            if (this.m.fixedIps == null) {
                this.m.fixedIps = Sets.newHashSet();
            }
            Iterator iter = this.m.fixedIps.iterator();
            while (iter.hasNext()) {
                NeutronIP fixedIP = (NeutronIP)iter.next();
                if (fixedIP.getSubnetId() == null || !fixedIP.getSubnetId().equals(subnetId) || fixedIP.getIpAddress() == null || !fixedIP.getIpAddress().equals(address)) continue;
                iter.remove();
            }
            return this;
        }

        @Override
        public PortBuilder allowedAddressPair(String ipAddress, String macAddress) {
            if (this.m.allowedAddressPairs == null) {
                this.m.allowedAddressPairs = Sets.newHashSet();
            }
            this.m.allowedAddressPairs.add(new NeutronAllowedAddressPair(ipAddress, macAddress));
            return this;
        }

        @Override
        public PortBuilder removeAddressPair(String ipAddress, String macAddress) {
            if (this.m.allowedAddressPairs == null) {
                this.m.allowedAddressPairs = Sets.newHashSet();
            }
            Iterator iter = this.m.allowedAddressPairs.iterator();
            while (iter.hasNext()) {
                NeutronAllowedAddressPair allowedAddress = (NeutronAllowedAddressPair)iter.next();
                if (allowedAddress.getIpAddress() == null || !allowedAddress.getIpAddress().equals(ipAddress) || allowedAddress.getMacAddress() == null || !allowedAddress.getMacAddress().equals(macAddress)) continue;
                iter.remove();
            }
            return this;
        }

        @Override
        public PortBuilder adminState(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public PortBuilder state(State state) {
            this.m.state = state;
            return this;
        }

        @Override
        public PortBuilder trunkPortParentId(String parentPortId) {
            this.m.trunkPortParentId = parentPortId;
            return this;
        }

        @Override
        public PortBuilder trunkPortType(String trunkPortType) {
            this.m.trunkPortType = trunkPortType;
            return this;
        }

        @Override
        public PortBuilder trunkPortVlanId(String vlanId) {
            this.m.trunkPortVlanId = vlanId;
            return this;
        }

        @Override
        public Port build() {
            return this.m;
        }

        @Override
        public PortBuilder from(Port in) {
            this.m = (NeutronPort)in;
            return this;
        }

        @Override
        protected Port reference() {
            return this.m;
        }

        @Override
        public PortBuilder extraDhcpOpt(ExtraDhcpOptCreate extraDhcpOptCreate) {
            if (this.m.extraDhcpOptCreates == null) {
                this.m.extraDhcpOptCreates = Lists.newArrayList();
            }
            this.m.extraDhcpOptCreates.add((NeutronExtraDhcpOptCreate)extraDhcpOptCreate);
            return this;
        }

        @Override
        public PortBuilder securityGroup(String groupName) {
            if (this.m.securityGroups == null) {
                this.m.securityGroups = new ArrayList();
            }
            this.m.securityGroups.add(groupName);
            return this;
        }

        @Override
        public PortBuilder portSecurityEnabled(Boolean portSecurityEnabled) {
            this.m.portSecurityEnabled = portSecurityEnabled;
            return this;
        }

        @Override
        public PortBuilder hostId(String hostId) {
            this.m.hostId = hostId;
            return this;
        }

        @Override
        public PortBuilder vifType(String vifType) {
            this.m.vifType = vifType;
            return this;
        }

        @Override
        public PortBuilder vifDetails(Map<String, Object> vifDetails) {
            this.m.vifDetails = vifDetails;
            return this;
        }

        @Override
        public PortBuilder vNicType(String vNicType) {
            this.m.vNicType = vNicType;
            return this;
        }

        @Override
        public PortBuilder profile(Map<String, Object> profile) {
            this.m.profile = profile;
            return this;
        }
    }

    public static class Ports
    extends ListResult<NeutronPort> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="ports")
        private List<NeutronPort> ports;

        @Override
        protected List<NeutronPort> value() {
            return this.ports;
        }
    }
}

