/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.openstack4j.api.Apis;
import org.openstack4j.model.network.ext.FirewallPolicy;
import org.openstack4j.model.network.ext.FirewallRule;
import org.openstack4j.model.network.ext.builder.FirewallPolicyBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.ext.NeutronFirewallPolicy;
import org.openstack4j.openstack.networking.domain.ext.NeutronFirewallRule;

public class AbstractNeutronFirewallPolicy
implements FirewallPolicy {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    @JsonProperty(value="tenant_id")
    protected String tenantId;
    protected String description;
    protected Boolean shared;
    protected Boolean audited;
    @JsonProperty(value="firewall_rules")
    protected List<String> firewallRules;
    protected List<NeutronFirewallRule> neutronFirewallRules;
    @JsonProperty(value="firewall_list")
    private List<String> firewallList;

    @Override
    public FirewallPolicyBuilder toBuilder() {
        return new FirewallPolicyConcreteBuilder(this);
    }

    public static FirewallPolicyBuilder builder() {
        return new FirewallPolicyConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean isShared() {
        return this.shared != null && this.shared != false;
    }

    @Override
    public Boolean isAudited() {
        return this.audited != null && this.audited != false;
    }

    @Override
    @JsonIgnore
    public List<String> getFirewallRuleIds() {
        return this.firewallRules;
    }

    @Override
    @JsonIgnore
    public List<? extends FirewallRule> getNeutronFirewallRules() {
        this.neutronFirewallRules = new ArrayList<NeutronFirewallRule>();
        if (this.neutronFirewallRules == null && this.firewallRules != null && this.firewallRules.size() > 0) {
            this.neutronFirewallRules = new ArrayList<NeutronFirewallRule>();
            for (String ruleId : this.firewallRules) {
                NeutronFirewallRule rule = (NeutronFirewallRule)Apis.getNetworkingServices().firewalls().firewallrule().get(ruleId);
                this.neutronFirewallRules.add(rule);
            }
        }
        return this.neutronFirewallRules;
    }

    @Override
    public List<String> getFirewallList() {
        return this.firewallList;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("shared", (Object)this.shared).add("audited", (Object)this.audited).add("tenantId", (Object)this.tenantId).add("description", (Object)this.description).add("firewallRuleIds", this.firewallRules).add("neutronFirewallRules", this.neutronFirewallRules).add("firewallList", this.firewallList).toString();
    }

    public static class FirewallPolicyConcreteBuilder
    implements FirewallPolicyBuilder {
        NeutronFirewallPolicy f;

        @Override
        public FirewallPolicy build() {
            return this.f;
        }

        public FirewallPolicyConcreteBuilder() {
            this(new NeutronFirewallPolicy());
        }

        public FirewallPolicyConcreteBuilder(FirewallPolicy f) {
            this.f = (NeutronFirewallPolicy)f;
        }

        @Override
        public FirewallPolicyBuilder from(FirewallPolicy in) {
            this.f = (NeutronFirewallPolicy)in;
            return this;
        }

        @Override
        public FirewallPolicyBuilder tenantId(String tenantId) {
            this.f.tenantId = tenantId;
            return this;
        }

        @Override
        public FirewallPolicyBuilder name(String name) {
            this.f.name = name;
            return this;
        }

        @Override
        public FirewallPolicyBuilder description(String description) {
            this.f.description = description;
            return this;
        }

        @Override
        public FirewallPolicyBuilder shared(Boolean shared) {
            this.f.shared = shared;
            return this;
        }

        @Override
        public FirewallPolicyBuilder audited(Boolean audited) {
            this.f.audited = audited;
            return this;
        }

        @Override
        public FirewallPolicyBuilder firewallRules(List<String> ruleIdList) {
            this.f.firewallRules = ruleIdList;
            return this;
        }
    }

    public static class FirewallPolicies
    extends ListResult<NeutronFirewallPolicy> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="firewall_policies")
        List<NeutronFirewallPolicy> firewallPolicies;

        @Override
        public List<NeutronFirewallPolicy> value() {
            return this.firewallPolicies;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("firewallPolicies", this.firewallPolicies).toString();
        }
    }
}

