/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.model.network.builder.NetSecurityGroupBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroupRule;

@JsonRootName(value="security_group")
public class NeutronSecurityGroup
implements SecurityGroup {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="security_group_rules")
    private List<NeutronSecurityGroupRule> rules;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public List<? extends SecurityGroupRule> getRules() {
        return this.rules;
    }

    @Override
    public NetSecurityGroupBuilder toBuilder() {
        return new SecurityGroupConcreteBuilder(this);
    }

    public static NetSecurityGroupBuilder builder() {
        return new SecurityGroupConcreteBuilder();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("tenantId", (Object)this.tenantId).add("name", (Object)this.name).add("description", (Object)this.description).add("security_group_rules", this.rules).addValue((Object)"\n").toString();
    }

    public static class SecurityGroupConcreteBuilder
    implements NetSecurityGroupBuilder {
        NeutronSecurityGroup g;

        public SecurityGroupConcreteBuilder() {
            this.g = new NeutronSecurityGroup();
        }

        public SecurityGroupConcreteBuilder(SecurityGroup in) {
            this.g = (NeutronSecurityGroup)in;
        }

        @Override
        public SecurityGroup build() {
            return this.g;
        }

        @Override
        public NetSecurityGroupBuilder from(SecurityGroup in) {
            this.g = (NeutronSecurityGroup)in;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder name(String name) {
            this.g.name = name;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder description(String description) {
            this.g.description = description;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder id(String id) {
            this.g.id = id;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder tenantId(String tenantId) {
            this.g.tenantId = tenantId;
            return this;
        }
    }

    public static class SecurityGroups
    extends ListResult<NeutronSecurityGroup> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="security_groups")
        private List<NeutronSecurityGroup> rules;

        @Override
        protected List<NeutronSecurityGroup> value() {
            return this.rules;
        }
    }
}

