/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.openstack4j.api.Apis;
import org.openstack4j.api.EndpointTokenProvider;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.CloudProvider;
import org.openstack4j.api.compute.ComputeService;
import org.openstack4j.api.gbp.GbpService;
import org.openstack4j.api.heat.HeatService;
import org.openstack4j.api.identity.EndpointURLResolver;
import org.openstack4j.api.identity.v2.IdentityService;
import org.openstack4j.api.image.ImageService;
import org.openstack4j.api.manila.ShareService;
import org.openstack4j.api.networking.NetworkingService;
import org.openstack4j.api.sahara.SaharaService;
import org.openstack4j.api.senlin.SenlinService;
import org.openstack4j.api.storage.BlockStorageService;
import org.openstack4j.api.storage.ObjectStorageService;
import org.openstack4j.api.telemetry.TelemetryService;
import org.openstack4j.api.types.Facing;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.model.identity.URLResolverParams;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.identity.internal.DefaultEndpointURLResolver;
import org.openstack4j.openstack.identity.v2.functions.ServiceToServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OSClientSession<R, T extends OSClient<T>>
implements EndpointTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OSClientSession.class);
    private static final ThreadLocal<OSClientSession> sessions = new ThreadLocal();
    EndpointURLResolver epr = new DefaultEndpointURLResolver();
    Config config;
    Facing perspective;
    String region;
    Set<ServiceType> supports;
    CloudProvider provider;

    public static OSClientSession getCurrent() {
        return sessions.get();
    }

    @VisibleForTesting
    public R useConfig(Config config) {
        this.config = config;
        return (R)this;
    }

    public T useRegion(String region) {
        this.region = region;
        return (T)((OSClient)((Object)this));
    }

    public T removeRegion() {
        return this.useRegion(null);
    }

    public Facing getPerspective() {
        return this.perspective;
    }

    public Config getConfig() {
        return this.config;
    }

    public ComputeService compute() {
        return Apis.getComputeServices();
    }

    public NetworkingService networking() {
        return Apis.getNetworkingServices();
    }

    public ImageService images() {
        return Apis.getImageService();
    }

    public BlockStorageService blockStorage() {
        return Apis.get(BlockStorageService.class);
    }

    public TelemetryService telemetry() {
        return Apis.get(TelemetryService.class);
    }

    public ShareService share() {
        return Apis.get(ShareService.class);
    }

    public HeatService heat() {
        return Apis.getHeatServices();
    }

    public SenlinService senlin() {
        return Apis.getSenlinServices();
    }

    public ObjectStorageService objectStorage() {
        return Apis.get(ObjectStorageService.class);
    }

    public SaharaService sahara() {
        return Apis.getSaharaServices();
    }

    public T perspective(Facing perspective) {
        this.perspective = perspective;
        return (T)((OSClient)((Object)this));
    }

    public CloudProvider getProvider() {
        return this.provider == null ? CloudProvider.UNKNOWN : this.provider;
    }

    public boolean supportsCompute() {
        return this.getSupportedServices().contains((Object)ServiceType.COMPUTE);
    }

    public boolean supportsIdentity() {
        return this.getSupportedServices().contains((Object)ServiceType.IDENTITY);
    }

    public boolean supportsNetwork() {
        return this.getSupportedServices().contains((Object)ServiceType.NETWORK);
    }

    public boolean supportsImage() {
        return this.getSupportedServices().contains((Object)ServiceType.IMAGE);
    }

    public boolean supportsHeat() {
        return this.getSupportedServices().contains((Object)ServiceType.ORCHESTRATION);
    }

    public boolean supportsBlockStorage() {
        return this.getSupportedServices().contains((Object)ServiceType.BLOCK_STORAGE);
    }

    public boolean supportsObjectStorage() {
        return this.getSupportedServices().contains((Object)ServiceType.OBJECT_STORAGE);
    }

    public boolean supportsTelemetry() {
        return this.getSupportedServices().contains((Object)ServiceType.TELEMETRY);
    }

    public boolean supportsShare() {
        return this.getSupportedServices().contains((Object)ServiceType.SHARE);
    }

    public Set<ServiceType> getSupportedServices() {
        return null;
    }

    public AuthVersion getAuthVersion() {
        return null;
    }

    public GbpService gbp() {
        return Apis.getGbpServices();
    }

    public static class OSClientSessionV3
    extends OSClientSession<OSClientSessionV3, OSClient.OSClientV3>
    implements OSClient.OSClientV3 {
        Token token;

        private OSClientSessionV3(Token token, String endpoint, Facing perspective, CloudProvider provider, Config config) {
            this.token = token;
            this.config = config;
            this.perspective = perspective;
            this.provider = provider;
            sessions.set(this);
        }

        private OSClientSessionV3(Token token, OSClientSessionV3 parent, String region) {
            this.token = parent.token;
            this.perspective = parent.perspective;
            this.region = region;
        }

        public static OSClientSessionV3 createSession(Token token) {
            return new OSClientSessionV3(token, token.getEndpoint(), null, null, null);
        }

        public static OSClientSessionV3 createSession(Token token, Facing perspective, CloudProvider provider, Config config) {
            return new OSClientSessionV3(token, token.getEndpoint(), perspective, provider, config);
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public String getEndpoint() {
            return this.token.getEndpoint();
        }

        @Override
        public AuthVersion getAuthVersion() {
            return AuthVersion.V3;
        }

        private String addNATIfApplicable(String url) {
            if (this.config != null && this.config.isBehindNAT()) {
                try {
                    URI uri = new URI(url);
                    return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
                }
                catch (URISyntaxException e) {
                    LoggerFactory.getLogger(OSClientSessionV3.class).error(e.getMessage(), (Throwable)e);
                }
            }
            return url;
        }

        @Override
        public String getEndpoint(ServiceType service) {
            return this.addNATIfApplicable(this.epr.findURLV3(URLResolverParams.create(this.token, service).resolver(this.config != null ? this.config.getResolver() : null).perspective(this.perspective).region(this.region)));
        }

        @Override
        public String getTokenId() {
            return this.token.getId();
        }

        @Override
        public org.openstack4j.api.identity.v3.IdentityService identity() {
            return Apis.getIdentityV3Services();
        }

        @Override
        public Set<ServiceType> getSupportedServices() {
            if (this.supports == null) {
                this.supports = Sets.immutableEnumSet((Iterable)Iterables.transform(this.token.getCatalog(), (Function)new org.openstack4j.openstack.identity.v3.functions.ServiceToServiceType()));
            }
            return this.supports;
        }
    }

    public static class OSClientSessionV2
    extends OSClientSession<OSClientSessionV2, OSClient.OSClientV2>
    implements OSClient.OSClientV2 {
        Access access;

        private OSClientSessionV2(Access access, String endpoint, Facing perspective, CloudProvider provider, Config config) {
            this.access = access;
            this.config = config;
            this.perspective = perspective;
            this.provider = provider;
            sessions.set(this);
        }

        private OSClientSessionV2(Access access, OSClientSessionV2 parent, String region) {
            this.access = parent.access;
            this.perspective = parent.perspective;
            this.region = region;
        }

        public static OSClientSessionV2 createSession(Access access) {
            return new OSClientSessionV2(access, access.getEndpoint(), null, null, null);
        }

        public static OSClientSessionV2 createSession(Access access, Facing perspective, CloudProvider provider, Config config) {
            return new OSClientSessionV2(access, access.getEndpoint(), perspective, provider, config);
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getEndpoint() {
            return this.access.getEndpoint();
        }

        @Override
        public AuthVersion getAuthVersion() {
            return AuthVersion.V2;
        }

        private String addNATIfApplicable(String url) {
            if (this.config != null && this.config.isBehindNAT()) {
                try {
                    URI uri = new URI(url);
                    return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
                }
                catch (URISyntaxException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            return url;
        }

        @Override
        public String getEndpoint(ServiceType service) {
            return this.addNATIfApplicable(this.epr.findURLV2(URLResolverParams.create(this.access, service).resolver(this.config != null ? this.config.getV2Resolver() : null).perspective(this.perspective).region(this.region)));
        }

        @Override
        public String getTokenId() {
            return this.access.getToken().getId();
        }

        @Override
        public IdentityService identity() {
            return Apis.getIdentityV2Services();
        }

        @Override
        public Set<ServiceType> getSupportedServices() {
            if (this.supports == null) {
                this.supports = Sets.immutableEnumSet((Iterable)Iterables.transform(this.access.getServiceCatalog(), (Function)new ServiceToServiceType()));
            }
            return this.supports;
        }
    }
}

