/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain.ext;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.model.compute.ext.Hypervisor;
import org.openstack4j.openstack.common.ListResult;
import org.slf4j.LoggerFactory;

public class ExtHypervisor
implements Hypervisor {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="current_workload")
    private int currentWorkload;
    @JsonProperty(value="disk_available_least")
    private int leastDiskAvailable;
    @JsonProperty(value="free_disk_gb")
    private int freeDisk;
    @JsonProperty(value="free_ram_mb")
    private int freeRam;
    @JsonProperty(value="hypervisor_type")
    private String type;
    @JsonProperty(value="hypervisor_hostname")
    private String hypervisorHostname;
    @JsonProperty(value="host_ip")
    private String hostIP;
    private int version;
    @JsonProperty(value="running_vms")
    private int runningVM;
    @JsonProperty(value="vcpus")
    private int virtualCPU;
    @JsonProperty(value="vcpus_used")
    private int virtualUsedCPU;
    @JsonProperty(value="local_gb")
    private int localDisk;
    @JsonProperty(value="local_gb_used")
    private int localDiskUsed;
    @JsonProperty(value="memory_mb")
    private int localMemory;
    @JsonProperty(value="memory_mb_used")
    private int localMemoryUsed;
    @JsonProperty(value="service")
    private HypervisorService service;
    @JsonProperty(value="cpu_info")
    private HypervisorCPUInfo cpuInfo;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getCurrentWorkload() {
        return this.currentWorkload;
    }

    @Override
    public int getLeastDiskAvailable() {
        return this.leastDiskAvailable;
    }

    @Override
    public int getFreeDisk() {
        return this.freeDisk;
    }

    @Override
    public int getFreeRam() {
        return this.freeRam;
    }

    @Override
    public String getHypervisorHostname() {
        return this.hypervisorHostname;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getRunningVM() {
        return this.runningVM;
    }

    @Override
    public int getVirtualCPU() {
        return this.virtualCPU;
    }

    @Override
    public int getVirtualUsedCPU() {
        return this.virtualUsedCPU;
    }

    @Override
    public int getLocalDisk() {
        return this.localDisk;
    }

    @Override
    public int getLocalDiskUsed() {
        return this.localDiskUsed;
    }

    @Override
    public int getLocalMemory() {
        return this.localMemory;
    }

    @Override
    public int getLocalMemoryUsed() {
        return this.localMemoryUsed;
    }

    @Override
    public Hypervisor.Service getService() {
        return this.service;
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public Hypervisor.CPUInfo getCPUInfo() {
        return this.cpuInfo;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("hypervisor_hostname", (Object)this.hypervisorHostname).add("version", this.version).add("type", (Object)this.type).add("host_ip", (Object)this.hostIP).add("running", this.runningVM).add("freeDisk", this.freeDisk).add("freeRam", this.freeRam).add("vcpus", this.virtualCPU).add("usedVcpu", this.virtualUsedCPU).add("localDisk", this.localDisk).add("localDiskUsed", this.localDiskUsed).add("localMemory", this.localMemory).add("localMemoryUsed", this.localMemoryUsed).add("currentWorkload", this.currentWorkload).add("leastDiskAvail", this.leastDiskAvailable).add("running_vms", this.runningVM).add("service", (Object)this.service).add("cpuInfo", (Object)this.cpuInfo).toString();
    }

    @JsonRootName(value="topology")
    static class HypervisorCPUTopology
    implements Hypervisor.CPUTopology {
        private static final long serialVersionUID = 1L;
        int cores;
        int threads;
        int sockets;

        HypervisorCPUTopology() {
        }

        @Override
        public int getCores() {
            return this.cores;
        }

        @Override
        public int getThreads() {
            return this.threads;
        }

        @Override
        public int getSockets() {
            return this.sockets;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("cores", this.cores).add("threads", this.threads).add("sockets", this.sockets).toString();
        }
    }

    static class HypervisorCPUInfo
    implements Hypervisor.CPUInfo {
        private static final long serialVersionUID = 1L;
        private String vendor;
        private String model;
        private String arch;
        private List<String> features;
        private HypervisorCPUTopology topology;

        HypervisorCPUInfo() {
        }

        @JsonCreator
        public static HypervisorCPUInfo value(String json) {
            if (json != null && json.length() > 0) {
                try {
                    return (HypervisorCPUInfo)ObjectMapperSingleton.getContext(HypervisorCPUInfo.class).reader(HypervisorCPUInfo.class).readValue(json);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(HypervisorCPUInfo.class).error(e.getMessage(), (Throwable)e);
                }
            }
            return null;
        }

        @Override
        public String getVendor() {
            return this.vendor;
        }

        @Override
        public String getModel() {
            return this.model;
        }

        @Override
        public String getArch() {
            return this.arch;
        }

        @Override
        public List<String> getFeatures() {
            return this.features;
        }

        @Override
        public Hypervisor.CPUTopology getTopology() {
            return this.topology;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("vendor", (Object)this.vendor).add("model", (Object)this.model).add("arch", (Object)this.arch).add("features", this.features).add("topology", (Object)this.topology).toString();
        }
    }

    public static class Hypervisors
    extends ListResult<ExtHypervisor> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="hypervisors")
        List<ExtHypervisor> hypervisors;

        @Override
        protected List<ExtHypervisor> value() {
            return this.hypervisors;
        }
    }

    @JsonRootName(value="service")
    static class HypervisorService
    implements Hypervisor.Service {
        private static final long serialVersionUID = 1L;
        private String host;
        private String id;

        HypervisorService() {
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("host", (Object)this.host).toString();
        }
    }
}

