/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;

public class UseLatestAggregationStrategy
implements AggregationStrategy {
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            return newExchange;
        }
        Exchange answer = null;
        this.propagateException(oldExchange, newExchange);
        if (newExchange.getException() != null) {
            answer = newExchange;
        }
        if (answer == null) {
            answer = this.propagateFailure(oldExchange, newExchange);
        }
        return answer;
    }

    protected void propagateException(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return;
        }
        if (newExchange.getException() == null) {
            newExchange.setException((Throwable)oldExchange.getException());
            newExchange.setProperty("CamelFailureEndpoint", oldExchange.getProperty("CamelFailureEndpoint"));
        }
    }

    protected Exchange propagateFailure(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange;
        }
        ExtendedExchange oee = (ExtendedExchange)oldExchange;
        if (oee.isFailed() || oee.isRollbackOnly() || oee.isRollbackOnlyLast() || oee.isErrorHandlerHandled()) {
            return oldExchange;
        }
        return newExchange;
    }

    public String toString() {
        return "UseLatestAggregationStrategy";
    }
}

