/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.model.identity.AuthStore;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.model.identity.v3.Authentication;
import org.openstack4j.openstack.common.Auth;
import org.openstack4j.openstack.common.BasicResourceEntity;
import org.openstack4j.openstack.common.IdResourceEntity;

@JsonRootName(value="auth")
public class KeystoneAuth
implements Authentication,
AuthStore {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private AuthIdentity identity;
    private AuthScope scope;
    @JsonIgnore
    private transient Auth.Type type;

    public KeystoneAuth(String tokenId, AuthScope scope) {
        this.identity = AuthIdentity.createTokenType(tokenId);
        this.scope = scope;
        this.type = Auth.Type.TOKEN;
    }

    public KeystoneAuth(String userId, String password) {
        this(userId, password, null, null);
    }

    public KeystoneAuth(String user, String password, Identifier domain, AuthScope scope) {
        this.identity = AuthIdentity.createCredentialType(user, password, domain);
        this.scope = scope;
        this.type = Auth.Type.CREDENTIALS;
    }

    protected KeystoneAuth(Auth.Type type) {
        this.type = type;
    }

    public Auth.Type getType() {
        return this.type;
    }

    @Override
    public Authentication.Identity getIdentity() {
        return this.identity;
    }

    @Override
    public Authentication.Scope getScope() {
        return this.scope;
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.identity.getPassword().getUser().getName();
    }

    @Override
    @JsonIgnore
    public String getPassword() {
        return this.identity.getPassword().getUser().getPassword();
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.identity.getPassword().getUser().getDomain().getId();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.identity.getPassword().getUser().getDomain().getName();
    }

    @Override
    @JsonIgnore
    public AuthVersion getVersion() {
        return AuthVersion.V3;
    }

    public static final class AuthScope
    implements Authentication.Scope {
        @JsonProperty(value="project")
        private ScopeProject project;
        @JsonProperty(value="domain")
        private AuthDomain domain;
        @JsonProperty(value="OS-TRUST:trust")
        private ScopeTrust trust;

        public AuthScope(ScopeProject project) {
            this.project = project;
        }

        public AuthScope(AuthDomain domain) {
            this.domain = domain;
        }

        public AuthScope(ScopeTrust trust) {
            this.trust = trust;
        }

        public static AuthScope project(Identifier project, Identifier domain) {
            return new AuthScope(ScopeProject.create(project, domain));
        }

        public static AuthScope project(Identifier project) {
            return new AuthScope(ScopeProject.create(project));
        }

        public static AuthScope domain(Identifier domain) {
            Preconditions.checkNotNull((Object)domain, (Object)"Domain Scope: domain identifier or name cannot be null");
            return new AuthScope(new AuthDomain(domain));
        }

        public static AuthScope trust(String id) {
            Preconditions.checkNotNull((Object)id, (Object)"Trust Scope: trust id cannot be null");
            return new AuthScope(new ScopeTrust(id));
        }

        @Override
        public Authentication.Scope.Project getProject() {
            return this.project;
        }

        @Override
        public Authentication.Scope.Domain getDomain() {
            return this.domain;
        }

        public static final class ScopeTrust
        extends IdResourceEntity {
            private static final long serialVersionUID = 1L;

            public ScopeTrust(String id) {
                this.setId(id);
            }
        }

        public static final class AuthDomain
        extends BasicResourceEntity
        implements Authentication.Scope.Domain {
            private static final long serialVersionUID = 1L;
            @JsonProperty
            private String id;
            @JsonProperty
            private String name;

            public AuthDomain(Identifier domain) {
                if (domain.isTypeID()) {
                    this.id = domain.getId();
                } else {
                    this.name = domain.getId();
                }
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        public static final class ScopeProject
        extends BasicResourceEntity
        implements Authentication.Scope.Project {
            private static final long serialVersionUID = 1L;
            private AuthDomain domain;
            @JsonProperty
            private String id;
            @JsonProperty
            private String name;

            public static ScopeProject create(Identifier project) {
                Preconditions.checkNotNull((Object)project, (Object)"Project Scope: project identifier or name cannot be null");
                ScopeProject scope = new ScopeProject();
                if (project.isTypeID()) {
                    scope.id = project.getId();
                }
                return scope;
            }

            public static ScopeProject create(Identifier project, Identifier domain) {
                Preconditions.checkNotNull((Object)project, (Object)"Project Scope: project identifier or name cannot be null");
                Preconditions.checkNotNull((Object)domain, (Object)"Project Scope: domain identifier or name cannot be null");
                ScopeProject scope = new ScopeProject();
                scope.domain = new AuthDomain(domain);
                if (project.isTypeID()) {
                    scope.id = project.getId();
                } else {
                    scope.name = project.getId();
                }
                return scope;
            }

            @Override
            public Authentication.Scope.Domain getDomain() {
                return this.domain;
            }

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public String getName() {
                return this.name;
            }
        }
    }

    public static final class AuthIdentity
    implements Authentication.Identity {
        private AuthPassword password;
        private AuthToken token;
        private List<String> methods = Lists.newArrayList();

        static AuthIdentity createTokenType(String tokenId) {
            AuthIdentity identity = new AuthIdentity();
            identity.methods.add("token");
            identity.token = new AuthToken(tokenId);
            return identity;
        }

        static AuthIdentity createCredentialType(String username, String password) {
            return AuthIdentity.createCredentialType(username, password, null);
        }

        static AuthIdentity createCredentialType(String username, String password, Identifier domain) {
            AuthIdentity identity = new AuthIdentity();
            identity.password = new AuthPassword(username, password, domain);
            identity.methods.add("password");
            return identity;
        }

        @Override
        public Authentication.Identity.Password getPassword() {
            return this.password;
        }

        @Override
        public Authentication.Identity.Token getToken() {
            return this.token;
        }

        @Override
        public List<String> getMethods() {
            return this.methods;
        }

        public static final class AuthPassword
        implements Authentication.Identity.Password {
            private AuthUser user;

            public AuthPassword() {
            }

            public AuthPassword(String username, String password, Identifier domain) {
                this.user = new AuthUser(username, password, domain);
            }

            @Override
            public Authentication.Identity.Password.User getUser() {
                return this.user;
            }

            public static final class AuthUser
            extends BasicResourceEntity
            implements Authentication.Identity.Password.User {
                private static final long serialVersionUID = 1L;
                private AuthDomain domain;
                private String password;

                public AuthUser() {
                }

                public AuthUser(String username, String password, Identifier domainIdentifier) {
                    this.password = password;
                    if (domainIdentifier != null) {
                        this.domain = new AuthDomain();
                        if (domainIdentifier.isTypeID()) {
                            this.domain.setId(domainIdentifier.getId());
                        } else {
                            this.domain.setName(domainIdentifier.getId());
                        }
                        this.setName(username);
                    } else {
                        this.setId(username);
                    }
                }

                @Override
                public Authentication.Identity.Password.User.Domain getDomain() {
                    return this.domain;
                }

                @Override
                public String getPassword() {
                    return this.password;
                }

                public static final class AuthDomain
                extends BasicResourceEntity
                implements Authentication.Identity.Password.User.Domain {
                    private static final long serialVersionUID = 1L;
                }
            }
        }

        public static final class AuthToken
        implements Authentication.Identity.Token {
            @JsonProperty
            private String id;

            AuthToken() {
            }

            AuthToken(String id) {
                this.id = id;
            }

            @Override
            public String getId() {
                return this.id;
            }
        }
    }
}

