/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Objects;
import java.util.List;
import org.openstack4j.model.identity.v2.Service;
import org.openstack4j.model.identity.v2.builder.ServiceBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="OS-KSADM:service")
public class KeystoneService
implements Service {
    private static final long serialVersionUID = 1L;
    String id;
    String type;
    String name;
    String description;

    public static ServiceBuilder builder() {
        return new ServiceConcreteBuilder();
    }

    @Override
    public ServiceBuilder toBuilder() {
        return new ServiceConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("description", (Object)this.description).toString();
    }

    public static class ServiceConcreteBuilder
    implements ServiceBuilder {
        private KeystoneService model;

        ServiceConcreteBuilder() {
            this(new KeystoneService());
        }

        ServiceConcreteBuilder(KeystoneService model) {
            this.model = model;
        }

        @Override
        public ServiceBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public ServiceBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public ServiceBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public Service build() {
            return this.model;
        }

        @Override
        public ServiceBuilder from(Service in) {
            this.model = (KeystoneService)in;
            return this;
        }
    }

    public static class Services
    extends ListResult<KeystoneService> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="OS-KSADM:services")
        private List<KeystoneService> list;

        @Override
        public List<KeystoneService> value() {
            return this.list;
        }
    }
}

