/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.openstack4j.api.networking.TrunkService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Trunk;
import org.openstack4j.model.network.TrunkSubport;
import org.openstack4j.openstack.networking.domain.AbstractNeutronTrunk;
import org.openstack4j.openstack.networking.domain.NeutronTrunk;
import org.openstack4j.openstack.networking.domain.NeutronTrunkCreate;
import org.openstack4j.openstack.networking.domain.NeutronTrunkSubport;
import org.openstack4j.openstack.networking.domain.NeutronTrunkSubportAddRemove;
import org.openstack4j.openstack.networking.domain.NeutronTrunkSubportCreate;
import org.openstack4j.openstack.networking.domain.NeutronTrunkUpdate;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class TrunkServiceImpl
extends BaseNetworkingServices
implements TrunkService {
    @Override
    public List<? extends Trunk> list() {
        return this.get(AbstractNeutronTrunk.Trunks.class, this.uri("/trunks", new Object[0])).execute().getList();
    }

    @Override
    public Trunk create(Trunk trunk) {
        Preconditions.checkNotNull((Object)trunk);
        return this.post(NeutronTrunk.class, this.uri("/trunks", new Object[0])).entity(NeutronTrunkCreate.fromTrunk(trunk)).execute();
    }

    @Override
    public Trunk get(String trunkId) {
        Preconditions.checkNotNull((Object)trunkId);
        return this.get(NeutronTrunk.class, this.uri("/trunks/%s", trunkId)).execute();
    }

    @Override
    public ActionResponse delete(String trunkId) {
        Preconditions.checkNotNull((Object)trunkId);
        return this.deleteWithResponse(this.uri("/trunks/%s", trunkId)).execute();
    }

    @Override
    public Trunk update(Trunk trunk) {
        Preconditions.checkNotNull((Object)trunk);
        Preconditions.checkNotNull((Object)trunk.getId());
        return this.put(NeutronTrunk.class, this.uri("/trunks/%s", trunk.getId())).entity(NeutronTrunkUpdate.update(trunk)).execute();
    }

    @Override
    public Trunk addTrunkSubport(String trunkId, TrunkSubport subPort) {
        Preconditions.checkNotNull((Object)subPort);
        Preconditions.checkNotNull((Object)trunkId);
        ArrayList<TrunkSubport> al = new ArrayList<TrunkSubport>();
        al.add(subPort);
        return this.put(NeutronTrunkSubportAddRemove.class, this.uri("/trunks/%s/add_subports", trunkId)).entity(NeutronTrunkSubportCreate.NeutronTrunkSubportsCreate.fromTrunkSubports(al)).execute();
    }

    @Override
    public Trunk removeTrunkSubport(String trunkId, String portId) {
        Preconditions.checkNotNull((Object)trunkId);
        Preconditions.checkNotNull((Object)portId);
        ArrayList<String> al = new ArrayList<String>();
        al.add(portId);
        return this.put(NeutronTrunkSubportAddRemove.class, this.uri("/trunks/%s/remove_subports", trunkId)).entity(NeutronTrunkSubportCreate.NeutronTrunkSubportDelete.NeutronTrunkSubportsDelete.delete(al)).execute();
    }

    @Override
    public List<NeutronTrunkSubport> listTrunkSubports(String trunkId) {
        Preconditions.checkNotNull((Object)trunkId);
        return this.get(NeutronTrunkSubport.TrunkSubports.class, this.uri("/trunks/%s/get_subports", trunkId)).execute().getList();
    }
}

