/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildConfigListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildConfigListFluentImpl<A extends BuildConfigListFluent<A>>
extends BaseFluent<A>
implements BuildConfigListFluent<A> {
    private String apiVersion;
    private List<BuildConfigBuilder> items = new ArrayList<BuildConfigBuilder>();
    private String kind;
    private ListMeta metadata;

    public BuildConfigListFluentImpl() {
    }

    public BuildConfigListFluentImpl(BuildConfigList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, BuildConfig item) {
        if (this.items == null) {
            this.items = new ArrayList<BuildConfigBuilder>();
        }
        BuildConfigBuilder builder = new BuildConfigBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, BuildConfig item) {
        if (this.items == null) {
            this.items = new ArrayList<BuildConfigBuilder>();
        }
        BuildConfigBuilder builder = new BuildConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(BuildConfig ... items) {
        if (this.items == null) {
            this.items = new ArrayList<BuildConfigBuilder>();
        }
        for (BuildConfig item : items) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<BuildConfig> items) {
        if (this.items == null) {
            this.items = new ArrayList<BuildConfigBuilder>();
        }
        for (BuildConfig item : items) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(BuildConfig ... items) {
        for (BuildConfig item : items) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<BuildConfig> items) {
        for (BuildConfig item : items) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<BuildConfigBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<BuildConfigBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            BuildConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildConfig> getItems() {
        return BuildConfigListFluentImpl.build(this.items);
    }

    @Override
    public List<BuildConfig> buildItems() {
        return BuildConfigListFluentImpl.build(this.items);
    }

    @Override
    public BuildConfig buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public BuildConfig buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public BuildConfig buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public BuildConfig buildMatchingItem(Predicate<BuildConfigBuilder> predicate) {
        for (BuildConfigBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<BuildConfigBuilder> predicate) {
        for (BuildConfigBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<BuildConfig> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<BuildConfigBuilder>();
            for (BuildConfig item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(BuildConfig ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (BuildConfig item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public BuildConfigListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public BuildConfigListFluent.ItemsNested<A> addNewItemLike(BuildConfig item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public BuildConfigListFluent.ItemsNested<A> setNewItemLike(int index, BuildConfig item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public BuildConfigListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public BuildConfigListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public BuildConfigListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public BuildConfigListFluent.ItemsNested<A> editMatchingItem(Predicate<BuildConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildConfigListFluentImpl that = (BuildConfigListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends BuildConfigFluentImpl<BuildConfigListFluent.ItemsNested<N>>
    implements BuildConfigListFluent.ItemsNested<N>,
    Nested<N> {
        private final BuildConfigBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, BuildConfig item) {
            this.index = index;
            this.builder = new BuildConfigBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new BuildConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildConfigListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

