/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ClusterRoleOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterRoleHandler
implements ResourceHandler<ClusterRole, ClusterRoleBuilder> {
    public String getKind() {
        return ClusterRole.class.getSimpleName();
    }

    public String getApiVersion() {
        return "authorization.openshift.io/v1";
    }

    public ClusterRole create(OkHttpClient client, Config config, String namespace, ClusterRole item) {
        return (ClusterRole)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ClusterRole[0]);
    }

    public ClusterRole replace(OkHttpClient client, Config config, String namespace, ClusterRole item) {
        return (ClusterRole)((Resource)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ClusterRole reload(OkHttpClient client, Config config, String namespace, ClusterRole item) {
        return (ClusterRole)((Gettable)((Resource)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ClusterRoleBuilder edit(ClusterRole item) {
        return new ClusterRoleBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterRole item) {
        return (Boolean)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).withPropagationPolicy(propagationPolicy).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRole item, Watcher<ClusterRole> watcher) {
        return (Watch)((Resource)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRole item, String resourceVersion, Watcher<ClusterRole> watcher) {
        return (Watch)((Resource)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRole item, ListOptions options, Watcher<ClusterRole> watcher) {
        return (Watch)((Resource)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ClusterRole waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterRole item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterRole)((Resource)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ClusterRole waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterRole item, Predicate<ClusterRole> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterRole)((Resource)new ClusterRoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

