/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers.rbac.v1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.rbac.v1.ClusterRoleOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterRoleHandler
implements ResourceHandler<ClusterRole, ClusterRoleBuilder> {
    @Override
    public String getKind() {
        return ClusterRole.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
    }

    @Override
    public ClusterRole create(OkHttpClient client, Config config, String namespace, ClusterRole item) {
        return (ClusterRole)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ClusterRole[0]);
    }

    @Override
    public ClusterRole replace(OkHttpClient client, Config config, String namespace, ClusterRole item) {
        return (ClusterRole)((Resource)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ClusterRole reload(OkHttpClient client, Config config, String namespace, ClusterRole item) {
        return (ClusterRole)((Gettable)((Resource)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ClusterRoleBuilder edit(ClusterRole item) {
        return new ClusterRoleBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterRole item) {
        return (Boolean)new ClusterRoleOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRole item, Watcher<ClusterRole> watcher) {
        return (Watch)((Resource)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRole item, String resourceVersion, Watcher<ClusterRole> watcher) {
        return (Watch)((Resource)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRole item, ListOptions options, Watcher<ClusterRole> watcher) {
        return (Watch)((Resource)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ClusterRole waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterRole item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterRole)((Resource)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ClusterRole waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterRole item, Predicate<ClusterRole> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterRole)((Resource)new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

