/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.SecurityContextFluentImpl;
import java.util.Objects;

public class SecurityContextBuilder
extends SecurityContextFluentImpl<SecurityContextBuilder>
implements VisitableBuilder<SecurityContext, SecurityContextBuilder> {
    SecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public SecurityContextBuilder() {
        this(true);
    }

    public SecurityContextBuilder(Boolean validationEnabled) {
        this(new SecurityContext(), validationEnabled);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecurityContext(), validationEnabled);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, SecurityContext instance) {
        this(fluent, instance, true);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, SecurityContext instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        fluent.withCapabilities(instance.getCapabilities());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withProcMount(instance.getProcMount());
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        fluent.withRunAsGroup(instance.getRunAsGroup());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
        fluent.withWindowsOptions(instance.getWindowsOptions());
        this.validationEnabled = validationEnabled;
    }

    public SecurityContextBuilder(SecurityContext instance) {
        this(instance, (Boolean)true);
    }

    public SecurityContextBuilder(SecurityContext instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        this.withCapabilities(instance.getCapabilities());
        this.withPrivileged(instance.getPrivileged());
        this.withProcMount(instance.getProcMount());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withWindowsOptions(instance.getWindowsOptions());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecurityContext build() {
        SecurityContext buildable = new SecurityContext(this.fluent.isAllowPrivilegeEscalation(), this.fluent.getCapabilities(), this.fluent.isPrivileged(), this.fluent.getProcMount(), this.fluent.isReadOnlyRootFilesystem(), this.fluent.getRunAsGroup(), this.fluent.isRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions(), this.fluent.getWindowsOptions());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextBuilder that = (SecurityContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

