/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.APIServer;
import io.fabric8.openshift.api.model.APIServerList;
import io.fabric8.openshift.api.model.ClusterOperator;
import io.fabric8.openshift.api.model.ClusterOperatorList;
import io.fabric8.openshift.api.model.ClusterVersion;
import io.fabric8.openshift.api.model.ClusterVersionList;
import io.fabric8.openshift.api.model.DoneableAPIServer;
import io.fabric8.openshift.api.model.DoneableClusterOperator;
import io.fabric8.openshift.api.model.DoneableClusterVersion;
import io.fabric8.openshift.api.model.DoneableFeatureGate;
import io.fabric8.openshift.api.model.DoneableInfrastructure;
import io.fabric8.openshift.api.model.DoneableOAuth;
import io.fabric8.openshift.api.model.DoneableOperatorHub;
import io.fabric8.openshift.api.model.DoneableProxy;
import io.fabric8.openshift.api.model.DoneableScheduler;
import io.fabric8.openshift.api.model.FeatureGate;
import io.fabric8.openshift.api.model.FeatureGateList;
import io.fabric8.openshift.api.model.Infrastructure;
import io.fabric8.openshift.api.model.InfrastructureList;
import io.fabric8.openshift.api.model.OAuth;
import io.fabric8.openshift.api.model.OAuthList;
import io.fabric8.openshift.api.model.OperatorHub;
import io.fabric8.openshift.api.model.OperatorHubList;
import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyList;
import io.fabric8.openshift.api.model.Scheduler;
import io.fabric8.openshift.api.model.SchedulerList;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.client.dsl.internal.APIServerOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ClusterOperatorOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ClusterVersionOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.FeatureGateOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.InfrastructureOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.OAuthOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.OperatorHubOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.ProxyOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.SchedulerOperationsImpl;
import okhttp3.OkHttpClient;

public class OpenShiftConfigAPIGroupClient
extends BaseClient
implements OpenShiftConfigAPIGroupDSL {
    public OpenShiftConfigAPIGroupClient() {
    }

    public OpenShiftConfigAPIGroupClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    @Override
    public NonNamespaceOperation<APIServer, APIServerList, DoneableAPIServer, Resource<APIServer, DoneableAPIServer>> apiServers() {
        return new APIServerOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterOperator, ClusterOperatorList, DoneableClusterOperator, Resource<ClusterOperator, DoneableClusterOperator>> clusterOperators() {
        return new ClusterOperatorOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterVersion, ClusterVersionList, DoneableClusterVersion, Resource<ClusterVersion, DoneableClusterVersion>> clusterVersions() {
        return new ClusterVersionOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<FeatureGate, FeatureGateList, DoneableFeatureGate, Resource<FeatureGate, DoneableFeatureGate>> featureGates() {
        return new FeatureGateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Infrastructure, InfrastructureList, DoneableInfrastructure, Resource<Infrastructure, DoneableInfrastructure>> infrastructures() {
        return new InfrastructureOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuth, OAuthList, DoneableOAuth, Resource<OAuth, DoneableOAuth>> oAuths() {
        return new OAuthOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OperatorHub, OperatorHubList, DoneableOperatorHub, Resource<OperatorHub, DoneableOperatorHub>> operatorHubs() {
        return new OperatorHubOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Proxy, ProxyList, DoneableProxy, Resource<Proxy, DoneableProxy>> proxies() {
        return new ProxyOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Scheduler, SchedulerList, DoneableScheduler, Resource<Scheduler, DoneableScheduler>> schedulers() {
        return new SchedulerOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }
}

