/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.discovery.Endpoint;
import io.fabric8.kubernetes.api.model.discovery.EndpointFluent;
import io.fabric8.kubernetes.api.model.discovery.EndpointFluentImpl;

public class EndpointBuilder
extends EndpointFluentImpl<EndpointBuilder>
implements VisitableBuilder<Endpoint, EndpointBuilder> {
    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder() {
        this(true);
    }

    public EndpointBuilder(Boolean validationEnabled) {
        this(new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance) {
        this(fluent, instance, true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withConditions(instance.getConditions());
        fluent.withHostname(instance.getHostname());
        fluent.withTargetRef(instance.getTargetRef());
        fluent.withTopology(instance.getTopology());
        this.validationEnabled = validationEnabled;
    }

    public EndpointBuilder(Endpoint instance) {
        this(instance, (Boolean)true);
    }

    public EndpointBuilder(Endpoint instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withConditions(instance.getConditions());
        this.withHostname(instance.getHostname());
        this.withTargetRef(instance.getTargetRef());
        this.withTopology(instance.getTopology());
        this.validationEnabled = validationEnabled;
    }

    public Endpoint build() {
        Endpoint buildable = new Endpoint(this.fluent.getAddresses(), this.fluent.getConditions(), this.fluent.getHostname(), this.fluent.getTargetRef(), this.fluent.getTopology());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointBuilder that = (EndpointBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

