/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.ClassFactory;
import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.moshi.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class ClassJsonAdapter<T>
extends JsonAdapter<T> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            Class<?> rawType = Types.getRawType(type);
            if (rawType.isInterface() || rawType.isEnum()) {
                return null;
            }
            if (this.isPlatformType(rawType)) {
                throw new IllegalArgumentException("Platform " + type + " annotated " + annotations + " requires explicit JsonAdapter to be registered");
            }
            if (!annotations.isEmpty()) {
                return null;
            }
            if (rawType.getEnclosingClass() != null && !Modifier.isStatic(rawType.getModifiers())) {
                if (rawType.getSimpleName().isEmpty()) {
                    throw new IllegalArgumentException("Cannot serialize anonymous class " + rawType.getName());
                }
                throw new IllegalArgumentException("Cannot serialize non-static nested class " + rawType.getName());
            }
            if (Modifier.isAbstract(rawType.getModifiers())) {
                throw new IllegalArgumentException("Cannot serialize abstract class " + rawType.getName());
            }
            ClassFactory classFactory = ClassFactory.get(rawType);
            TreeMap fields = new TreeMap();
            Type t = type;
            while (t != Object.class) {
                this.createFieldBindings(moshi, t, fields);
                t = Types.getGenericSuperclass(t);
            }
            return new ClassJsonAdapter(classFactory, fields).nullSafe();
        }

        private void createFieldBindings(Moshi moshi, Type type, Map<String, FieldBinding<?>> fieldBindings) {
            Class<?> rawType = Types.getRawType(type);
            boolean platformType = this.isPlatformType(rawType);
            for (Field field : rawType.getDeclaredFields()) {
                if (!this.includeField(platformType, field.getModifiers())) continue;
                Type fieldType = Types.resolve(type, rawType, field.getGenericType());
                Set<? extends Annotation> annotations = Util.jsonAnnotations(field);
                JsonAdapter adapter = moshi.adapter(fieldType, annotations);
                field.setAccessible(true);
                FieldBinding fieldBinding = new FieldBinding(field, adapter);
                Json jsonAnnotation = field.getAnnotation(Json.class);
                String name = jsonAnnotation != null ? jsonAnnotation.name() : field.getName();
                FieldBinding replaced = fieldBindings.put(name, fieldBinding);
                if (replaced == null) continue;
                throw new IllegalArgumentException("Conflicting fields:\n    " + replaced.field + "\n" + "    " + fieldBinding.field);
            }
        }

        private boolean isPlatformType(Class<?> rawType) {
            return rawType.getName().startsWith("java.") || rawType.getName().startsWith("javax.") || rawType.getName().startsWith("android.");
        }

        private boolean includeField(boolean platformType, int modifiers) {
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) {
                return false;
            }
            return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !platformType;
        }
    };
    private final ClassFactory<T> classFactory;
    private final Map<String, FieldBinding<?>> jsonFields;

    ClassJsonAdapter(ClassFactory<T> classFactory, Map<String, FieldBinding<?>> jsonFields) {
        this.classFactory = classFactory;
        this.jsonFields = jsonFields;
    }

    @Override
    public T fromJson(JsonReader reader) throws IOException {
        T result;
        try {
            result = this.classFactory.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new RuntimeException(targetException);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                FieldBinding<?> fieldBinding = this.jsonFields.get(name);
                if (fieldBinding != null) {
                    fieldBinding.read(reader, result);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void toJson(JsonWriter writer, T value) throws IOException {
        try {
            writer.beginObject();
            for (Map.Entry<String, FieldBinding<?>> entry : this.jsonFields.entrySet()) {
                writer.name(entry.getKey());
                entry.getValue().write(writer, value);
            }
            writer.endObject();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "JsonAdapter(" + this.classFactory + ")";
    }

    static class FieldBinding<T> {
        private final Field field;
        private final JsonAdapter<T> adapter;

        public FieldBinding(Field field, JsonAdapter<T> adapter) {
            this.field = field;
            this.adapter = adapter;
        }

        void read(JsonReader reader, Object value) throws IOException, IllegalAccessException {
            T fieldValue = this.adapter.fromJson(reader);
            this.field.set(value, fieldValue);
        }

        void write(JsonWriter writer, Object value) throws IllegalAccessException, IOException {
            Object fieldValue = this.field.get(value);
            this.adapter.toJson(writer, fieldValue);
        }
    }
}

