/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.deployments;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.component.kubernetes.consumer.common.DeploymentEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDeploymentsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesDeploymentsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private DeploymentsConsumerTask deploymentsWatcher;

    public KubernetesDeploymentsConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.deploymentsWatcher = new DeploymentsConsumerTask();
        this.executor.submit(this.deploymentsWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Deployments Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.deploymentsWatcher, this.deploymentsWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class DeploymentsConsumerTask
    implements Runnable {
        private Watch watch;

        DeploymentsConsumerTask() {
        }

        @Override
        public void run() {
            MixedOperation w = KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesClient().apps().deployments();
            if (ObjectHelper.isNotEmpty((Object)KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty((Object)KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            if (ObjectHelper.isNotEmpty((Object)KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName())) {
                w.withName(KubernetesDeploymentsConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName());
            }
            this.watch = w.watch((Object)new Watcher<Deployment>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void eventReceived(Watcher.Action action, Deployment resource) {
                    DeploymentEvent de = new DeploymentEvent(action, resource);
                    Exchange exchange = KubernetesDeploymentsConsumer.this.createExchange(false);
                    exchange.getIn().setBody((Object)de.getDeployment());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)de.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesDeploymentsConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesDeploymentsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                    finally {
                        KubernetesDeploymentsConsumer.this.releaseExchange(exchange, false);
                    }
                }

                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

