/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import java.util.function.Supplier;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHelper.class);

    private KubernetesHelper() {
    }

    public static KubernetesClient getKubernetesClient(KubernetesConfiguration configuration) {
        if (configuration.getKubernetesClient() != null) {
            return configuration.getKubernetesClient();
        }
        if (configuration.getMasterUrl() != null) {
            return KubernetesHelper.createKubernetesClient(configuration);
        }
        LOG.info("Creating default kubernetes client without applying configuration");
        return new DefaultKubernetesClient();
    }

    private static KubernetesClient createKubernetesClient(KubernetesConfiguration configuration) {
        LOG.debug("Create Kubernetes client with the following Configuration: {}", (Object)configuration);
        ConfigBuilder builder = new ConfigBuilder();
        builder.withMasterUrl(configuration.getMasterUrl());
        if (ObjectHelper.isNotEmpty((Object)configuration.getUsername()) && ObjectHelper.isNotEmpty((Object)configuration.getPassword()) && ObjectHelper.isEmpty((Object)configuration.getOauthToken())) {
            builder.withUsername(configuration.getUsername());
            builder.withPassword(configuration.getPassword());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getOauthToken())) {
            builder.withOauthToken(configuration.getOauthToken());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getCaCertData())) {
            builder.withCaCertData(configuration.getCaCertData());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getCaCertFile())) {
            builder.withCaCertFile(configuration.getCaCertFile());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getClientCertData())) {
            builder.withClientCertData(configuration.getClientCertData());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getClientCertFile())) {
            builder.withClientCertFile(configuration.getClientCertFile());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getApiVersion())) {
            builder.withApiVersion(configuration.getApiVersion());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyAlgo())) {
            builder.withClientKeyAlgo(configuration.getClientKeyAlgo());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyData())) {
            builder.withClientKeyData(configuration.getClientKeyData());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyFile())) {
            builder.withClientKeyFile(configuration.getClientKeyFile());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getClientKeyPassphrase())) {
            builder.withClientKeyPassphrase(configuration.getClientKeyPassphrase());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getTrustCerts())) {
            builder.withTrustCerts(configuration.getTrustCerts().booleanValue());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getConnectionTimeout())) {
            builder.withConnectionTimeout(configuration.getConnectionTimeout().intValue());
        }
        if (ObjectHelper.isNotEmpty((Object)configuration.getNamespace())) {
            builder.withNamespace(configuration.getNamespace());
        }
        Config conf = builder.build();
        return new DefaultKubernetesClient(conf);
    }

    public static void close(Runnable runnable, Supplier<Watch> watchGetter) {
        Watch watch;
        if (runnable != null && (watch = watchGetter.get()) != null) {
            watch.close();
        }
    }
}

