/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.console;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.console.v1.ConsoleLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleLinkBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleLinkOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ConsoleLinkHandler
implements ResourceHandler<ConsoleLink, ConsoleLinkBuilder> {
    public String getKind() {
        return ConsoleLink.class.getSimpleName();
    }

    public String getApiVersion() {
        return "console.openshift.io/v1";
    }

    public ConsoleLink create(OkHttpClient client, Config config, String namespace, ConsoleLink item, boolean dryRun) {
        return (ConsoleLink)((WritableOperation)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new ConsoleLink[0]);
    }

    public ConsoleLink replace(OkHttpClient client, Config config, String namespace, ConsoleLink item, boolean dryRun) {
        return (ConsoleLink)((WritableOperation)((Resource)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public ConsoleLink reload(OkHttpClient client, Config config, String namespace, ConsoleLink item) {
        return (ConsoleLink)((Gettable)((Resource)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ConsoleLinkBuilder edit(ConsoleLink item) {
        return new ConsoleLinkBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ConsoleLink item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleLink item, Watcher<ConsoleLink> watcher) {
        return ((Resource)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleLink item, String resourceVersion, Watcher<ConsoleLink> watcher) {
        return ((Resource)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ConsoleLink item, ListOptions options, Watcher<ConsoleLink> watcher) {
        return ((Resource)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public ConsoleLink waitUntilReady(OkHttpClient client, Config config, String namespace, ConsoleLink item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConsoleLink)((Resource)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ConsoleLink waitUntilCondition(OkHttpClient client, Config config, String namespace, ConsoleLink item, Predicate<ConsoleLink> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ConsoleLink)((Resource)new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

