/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.Infrastructure;
import io.fabric8.openshift.api.model.InfrastructureBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.config.InfrastructureOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class InfrastructureHandler
implements ResourceHandler<Infrastructure, InfrastructureBuilder> {
    public String getKind() {
        return Infrastructure.class.getSimpleName();
    }

    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    public Infrastructure create(OkHttpClient client, Config config, String namespace, Infrastructure item, boolean dryRun) {
        return (Infrastructure)((WritableOperation)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Infrastructure[0]);
    }

    public Infrastructure replace(OkHttpClient client, Config config, String namespace, Infrastructure item, boolean dryRun) {
        return (Infrastructure)((WritableOperation)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Infrastructure reload(OkHttpClient client, Config config, String namespace, Infrastructure item) {
        return (Infrastructure)((Gettable)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public InfrastructureBuilder edit(Infrastructure item) {
        return new InfrastructureBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Infrastructure item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, Watcher<Infrastructure> watcher) {
        return ((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, String resourceVersion, Watcher<Infrastructure> watcher) {
        return ((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Infrastructure item, ListOptions options, Watcher<Infrastructure> watcher) {
        return ((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Infrastructure waitUntilReady(OkHttpClient client, Config config, String namespace, Infrastructure item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Infrastructure)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Infrastructure waitUntilCondition(OkHttpClient client, Config config, String namespace, Infrastructure item, Predicate<Infrastructure> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Infrastructure)((Resource)new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

