/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.apps;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.internal.apps.DeploymentConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DeploymentConfigHandler
implements ResourceHandler<DeploymentConfig, DeploymentConfigBuilder> {
    public String getKind() {
        return DeploymentConfig.class.getSimpleName();
    }

    public String getApiVersion() {
        return "apps.openshift.io/v1";
    }

    public DeploymentConfig create(OkHttpClient client, Config config, String namespace, DeploymentConfig item, boolean dryRun) {
        return (DeploymentConfig)((WritableOperation)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new DeploymentConfig[0]);
    }

    public DeploymentConfig replace(OkHttpClient client, Config config, String namespace, DeploymentConfig item, boolean dryRun) {
        return (DeploymentConfig)((WritableOperation)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public DeploymentConfig reload(OkHttpClient client, Config config, String namespace, DeploymentConfig item) {
        return (DeploymentConfig)((Gettable)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public DeploymentConfigBuilder edit(DeploymentConfig item) {
        return new DeploymentConfigBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, DeploymentConfig item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, Watcher<DeploymentConfig> watcher) {
        return ((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, String resourceVersion, Watcher<DeploymentConfig> watcher) {
        return ((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, DeploymentConfig item, ListOptions options, Watcher<DeploymentConfig> watcher) {
        return ((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public DeploymentConfig waitUntilReady(OkHttpClient client, Config config, String namespace, DeploymentConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DeploymentConfig)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public DeploymentConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, DeploymentConfig item, Predicate<DeploymentConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DeploymentConfig)((DeployableScalableResource)new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

