/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OAuthClientOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class OAuthClientHandler
implements ResourceHandler<OAuthClient, OAuthClientBuilder> {
    public String getKind() {
        return OAuthClient.class.getSimpleName();
    }

    public String getApiVersion() {
        return "oauth.openshift.io/v1";
    }

    public OAuthClient create(OkHttpClient client, Config config, String namespace, OAuthClient item) {
        return (OAuthClient)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create((Object[])new OAuthClient[0]);
    }

    public OAuthClient replace(OkHttpClient client, Config config, String namespace, OAuthClient item) {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public OAuthClient reload(OkHttpClient client, Config config, String namespace, OAuthClient item) {
        return (OAuthClient)((Gettable)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public OAuthClientBuilder edit(OAuthClient item) {
        return new OAuthClientBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, OAuthClient item) {
        if (cascading.booleanValue()) {
            return (Boolean)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete((Object[])new OAuthClient[]{item});
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, Watcher<OAuthClient> watcher) {
        return (Watch)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, OAuthClient item, String resourceVersion, Watcher<OAuthClient> watcher) {
        return (Watch)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public OAuthClient waitUntilReady(OkHttpClient client, Config config, String namespace, OAuthClient item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public OAuthClient waitUntilCondition(OkHttpClient client, Config config, String namespace, OAuthClient item, Predicate<OAuthClient> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (OAuthClient)((Resource)new OAuthClientOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

