/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.strategy.ArtifactCoordinates;
import io.apicurio.registry.resolver.strategy.ArtifactReference;

public class SchemaLookupResult<T> {
    private ParsedSchema<T> parsedSchema;
    private long globalId;
    private long contentId;
    private String contentHash;
    private String groupId;
    private String artifactId;
    private String version;

    private SchemaLookupResult() {
    }

    public ParsedSchema<T> getParsedSchema() {
        return this.parsedSchema;
    }

    public long getGlobalId() {
        return this.globalId;
    }

    public long getContentId() {
        return this.contentId;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public ArtifactReference toArtifactReference() {
        return ArtifactReference.builder().globalId(this.getGlobalId()).contentId(this.getContentId()).contentHash(this.getContentHash()).groupId(this.getGroupId()).artifactId(this.getArtifactId()).version(this.getVersion()).build();
    }

    public ArtifactCoordinates toArtifactCoordinates() {
        return ArtifactCoordinates.builder().groupId(this.getGroupId()).artifactId(this.getArtifactId()).version(this.getVersion()).build();
    }

    public static <T> SchemaLookupResultBuilder<T> builder() {
        return new SchemaLookupResultBuilder();
    }

    public static class SchemaLookupResultBuilder<T> {
        private SchemaLookupResult<T> result = new SchemaLookupResult();

        SchemaLookupResultBuilder() {
        }

        public SchemaLookupResultBuilder<T> parsedSchema(ParsedSchema<T> parsedSchema) {
            this.result.parsedSchema = parsedSchema;
            return this;
        }

        public SchemaLookupResultBuilder<T> globalId(long globalId) {
            this.result.globalId = globalId;
            return this;
        }

        public SchemaLookupResultBuilder<T> contentId(long contentId) {
            this.result.contentId = contentId;
            return this;
        }

        public SchemaLookupResultBuilder<T> contentHash(String contentHash) {
            this.result.contentHash = contentHash;
            return this;
        }

        public SchemaLookupResultBuilder<T> groupId(String groupId) {
            this.result.groupId = groupId;
            return this;
        }

        public SchemaLookupResultBuilder<T> artifactId(String artifactId) {
            this.result.artifactId = artifactId;
            return this;
        }

        public SchemaLookupResultBuilder<T> version(String version) {
            this.result.version = version;
            return this;
        }

        public SchemaLookupResult<T> build() {
            return this.result;
        }
    }
}

