/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.DebugTab;

public class DebugTabRequest
implements DebugTab {
    private static final String UNKOWN_MSG = "unkown";
    private final String method;
    private final String uri;
    private final String protocol;
    private final Map<String, List<String>> headers;

    public DebugTabRequest(ODataRequest request) {
        if (request != null) {
            this.method = request.getMethod() == null ? UNKOWN_MSG : request.getMethod().toString();
            this.uri = request.getRawRequestUri() == null ? UNKOWN_MSG : request.getRawRequestUri();
            this.protocol = request.getProtocol() == null ? UNKOWN_MSG : request.getProtocol();
            this.headers = request.getAllHeaders();
        } else {
            this.method = UNKOWN_MSG;
            this.uri = UNKOWN_MSG;
            this.protocol = UNKOWN_MSG;
            this.headers = Collections.emptyMap();
        }
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        writer.append("<h2>Request Method</h2>\n").append("<p>").append(this.method).append("</p>\n").append("<h2>Request URI</h2>\n").append("<p>").append(DebugResponseHelperImpl.escapeHtml(this.uri)).append("</p>\n").append("<h2>Request Protocol</h2>\n").append("<p>").append(DebugResponseHelperImpl.escapeHtml(this.protocol)).append("</p>\n");
        writer.append("<h2>Request Headers</h2>\n");
        writer.append("<table>\n<thead>\n").append("<tr><th class=\"name\">Name</th><th class=\"value\">Value</th></tr>\n").append("</thead>\n<tbody>\n");
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            List<String> headersList = entry.getValue();
            if (headersList == null || headersList.isEmpty()) continue;
            for (String headerValue : headersList) {
                writer.append("<tr><td class=\"name\">").append(entry.getKey()).append("</td>").append("<td class=\"value\">").append(DebugResponseHelperImpl.escapeHtml(headerValue)).append("</td></tr>\n");
            }
        }
        writer.append("</tbody>\n</table>\n");
    }

    @Override
    public String getName() {
        return "Request";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("method", this.method);
        gen.writeStringField("uri", this.uri);
        gen.writeStringField("protocol", this.protocol);
        if (!this.headers.isEmpty()) {
            gen.writeFieldName("headers");
            gen.writeStartObject();
            for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                List<String> headersList = entry.getValue();
                if (headersList != null && !headersList.isEmpty()) {
                    if (headersList.size() == 1) {
                        gen.writeStringField(entry.getKey(), headersList.get(0));
                        continue;
                    }
                    gen.writeFieldName(entry.getKey());
                    gen.writeStartArray();
                    for (String headerValue : headersList) {
                        if (headerValue != null) {
                            gen.writeString(headerValue);
                            continue;
                        }
                        gen.writeNull();
                    }
                    gen.writeEndArray();
                    continue;
                }
                gen.writeNullField(entry.getKey());
            }
            gen.writeEndObject();
        }
        gen.writeEndObject();
    }
}

