/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.data.ServiceDocument;
import org.apache.olingo.client.api.data.ServiceDocumentItem;
import org.apache.olingo.client.api.domain.ClientAnnotatable;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientDeletedEntity;
import org.apache.olingo.client.api.domain.ClientDelta;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientInlineEntity;
import org.apache.olingo.client.api.domain.ClientInlineEntitySet;
import org.apache.olingo.client.api.domain.ClientItem;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientLinkType;
import org.apache.olingo.client.api.domain.ClientLinked;
import org.apache.olingo.client.api.domain.ClientOperation;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientServiceDocument;
import org.apache.olingo.client.api.domain.ClientValuable;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.serialization.ODataBinder;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.domain.ClientAnnotationImpl;
import org.apache.olingo.client.core.domain.ClientDeletedEntityImpl;
import org.apache.olingo.client.core.domain.ClientDeltaLinkImpl;
import org.apache.olingo.client.core.domain.ClientPropertyImpl;
import org.apache.olingo.client.core.serialization.ContextURLParser;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.DeltaLink;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataBinderImpl
implements ODataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(ODataBinderImpl.class);
    protected final ODataClient client;

    public ODataBinderImpl(ODataClient client) {
        this.client = client;
    }

    public boolean add(ClientEntity entity, ClientProperty property) {
        return entity.getProperties().add(property);
    }

    protected boolean add(ClientEntitySet entitySet, ClientEntity entity) {
        return entitySet.getEntities().add(entity);
    }

    public ClientServiceDocument getODataServiceDocument(ServiceDocument resource) {
        ClientServiceDocument serviceDocument = new ClientServiceDocument();
        for (ServiceDocumentItem entitySet : resource.getEntitySets()) {
            serviceDocument.getEntitySets().put(entitySet.getName(), URIUtils.getURI(resource.getBaseURI(), entitySet.getUrl()));
        }
        for (ServiceDocumentItem functionImport : resource.getFunctionImports()) {
            serviceDocument.getFunctionImports().put(functionImport.getName() == null ? functionImport.getUrl() : functionImport.getName(), URIUtils.getURI(resource.getBaseURI(), functionImport.getUrl()));
        }
        for (ServiceDocumentItem singleton : resource.getSingletons()) {
            serviceDocument.getSingletons().put(singleton.getName() == null ? singleton.getUrl() : singleton.getName(), URIUtils.getURI(resource.getBaseURI(), singleton.getUrl()));
        }
        for (ServiceDocumentItem sdoc : resource.getRelatedServiceDocuments()) {
            serviceDocument.getRelatedServiceDocuments().put(sdoc.getName() == null ? sdoc.getUrl() : sdoc.getName(), URIUtils.getURI(resource.getBaseURI(), sdoc.getUrl()));
        }
        return serviceDocument;
    }

    private void updateValuable(Valuable propertyResource, ClientValuable odataValuable) {
        Object propertyValue = this.getValue(odataValuable.getValue());
        if (odataValuable.hasPrimitiveValue()) {
            propertyResource.setType(odataValuable.getPrimitiveValue().getTypeName());
            propertyResource.setValue(propertyValue instanceof Geospatial ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, propertyValue);
        } else if (odataValuable.hasEnumValue()) {
            propertyResource.setType(odataValuable.getEnumValue().getTypeName());
            propertyResource.setValue(ValueType.ENUM, propertyValue);
        } else if (odataValuable.hasComplexValue()) {
            propertyResource.setType(odataValuable.getComplexValue().getTypeName());
            propertyResource.setValue(ValueType.COMPLEX, propertyValue);
        } else if (odataValuable.hasCollectionValue()) {
            ClientCollectionValue collectionValue = odataValuable.getCollectionValue();
            propertyResource.setType(collectionValue.getTypeName());
            ClientValue value = collectionValue.iterator().hasNext() ? (ClientValue)collectionValue.iterator().next() : null;
            ValueType valueType = ValueType.COLLECTION_PRIMITIVE;
            if (value == null) {
                valueType = ValueType.COLLECTION_PRIMITIVE;
            } else if (value.isPrimitive()) {
                valueType = value.asPrimitive().toValue() instanceof Geospatial ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE;
            } else if (value.isEnum()) {
                valueType = ValueType.COLLECTION_ENUM;
            } else if (value.isComplex()) {
                valueType = ValueType.COLLECTION_COMPLEX;
            }
            propertyResource.setValue(valueType, propertyValue);
        }
    }

    private void annotations(ClientAnnotatable odataAnnotatable, Annotatable annotatable) {
        for (ClientAnnotation odataAnnotation : odataAnnotatable.getAnnotations()) {
            Annotation annotation = new Annotation();
            annotation.setTerm(odataAnnotation.getTerm());
            annotation.setType(odataAnnotation.getValue().getTypeName());
            this.updateValuable((Valuable)annotation, (ClientValuable)odataAnnotation);
            annotatable.getAnnotations().add(annotation);
        }
    }

    public EntityCollection getEntitySet(ClientEntitySet odataEntitySet) {
        EntityCollection entitySet = new EntityCollection();
        entitySet.setCount(odataEntitySet.getCount());
        URI next = odataEntitySet.getNext();
        if (next != null) {
            entitySet.setNext(next);
        }
        for (ClientEntity entity : odataEntitySet.getEntities()) {
            entitySet.getEntities().add(this.getEntity(entity));
        }
        entitySet.setDeltaLink(odataEntitySet.getDeltaLink());
        this.annotations((ClientAnnotatable)odataEntitySet, (Annotatable)entitySet);
        return entitySet;
    }

    protected void links(ClientLinked odataLinked, Linked linked) {
        for (ClientLink link : odataLinked.getNavigationLinks()) {
            LOG.debug("Append navigation link\n{}", (Object)link);
            linked.getNavigationLinks().add(this.getLink(link));
        }
        for (ClientLink link : odataLinked.getAssociationLinks()) {
            LOG.debug("Append association link\n{}", (Object)link);
            linked.getAssociationLinks().add(this.getLink(link));
        }
        for (ClientLink link : linked.getNavigationLinks()) {
            ClientLink odataLink = odataLinked.getNavigationLink(link.getTitle());
            if (odataLink instanceof ClientInlineEntity || odataLink instanceof ClientInlineEntitySet) continue;
            this.annotations((ClientAnnotatable)odataLink, (Annotatable)link);
        }
    }

    public Entity getEntity(ClientEntity odataEntity) {
        Entity entity = new Entity();
        entity.setType(odataEntity.getTypeName() == null ? null : odataEntity.getTypeName().toString());
        URI odataEditLink = odataEntity.getEditLink();
        if (odataEditLink != null) {
            Link editLink = new Link();
            editLink.setTitle(entity.getType());
            editLink.setHref(odataEditLink.toASCIIString());
            editLink.setRel("edit");
            entity.setEditLink(editLink);
        }
        if (odataEntity.isReadOnly()) {
            Link selfLink = new Link();
            selfLink.setTitle(entity.getType());
            selfLink.setHref(odataEntity.getLink().toASCIIString());
            selfLink.setRel("self");
            entity.setSelfLink(selfLink);
        }
        this.links((ClientLinked)odataEntity, (Linked)entity);
        for (ClientLink link : odataEntity.getMediaEditLinks()) {
            LOG.debug("Append edit-media link\n{}", (Object)link);
            entity.getMediaEditLinks().add(this.getLink(link));
        }
        if (odataEntity.isMediaEntity()) {
            entity.setMediaContentSource(odataEntity.getMediaContentSource());
            entity.setMediaContentType(odataEntity.getMediaContentType());
            entity.setMediaETag(odataEntity.getMediaETag());
        }
        for (ClientProperty property : odataEntity.getProperties()) {
            entity.getProperties().add(this.getProperty(property));
        }
        entity.setId(odataEntity.getId());
        this.annotations((ClientAnnotatable)odataEntity, (Annotatable)entity);
        return entity;
    }

    public Link getLink(ClientLink link) {
        Link linkResource = new Link();
        linkResource.setRel(link.getRel());
        linkResource.setTitle(link.getName());
        linkResource.setHref(link.getLink() == null ? null : link.getLink().toASCIIString());
        linkResource.setType(link.getType().toString());
        linkResource.setMediaETag(link.getMediaETag());
        if (link instanceof ClientInlineEntity) {
            ClientEntity inlineEntity = ((ClientInlineEntity)link).getEntity();
            LOG.debug("Append in-line entity\n{}", (Object)inlineEntity);
            linkResource.setInlineEntity(this.getEntity(inlineEntity));
        } else if (link instanceof ClientInlineEntitySet) {
            ClientEntitySet InlineEntitySet = ((ClientInlineEntitySet)link).getEntitySet();
            LOG.debug("Append in-line entity set\n{}", (Object)InlineEntitySet);
            linkResource.setInlineEntitySet(this.getEntitySet(InlineEntitySet));
        }
        return linkResource;
    }

    public Property getProperty(ClientProperty property) {
        Property propertyResource = new Property();
        propertyResource.setName(property.getName());
        this.updateValuable((Valuable)propertyResource, (ClientValuable)property);
        this.annotations((ClientAnnotatable)property, (Annotatable)propertyResource);
        return propertyResource;
    }

    protected Object getValue(ClientValue value) {
        ComplexValue valueResource = null;
        if (value == null) {
            return null;
        }
        if (value.isEnum()) {
            valueResource = value.asEnum().getValue();
        } else if (value.isPrimitive()) {
            valueResource = value.asPrimitive().toValue();
        } else if (value.isComplex()) {
            ArrayList<Property> complexProperties = new ArrayList<Property>();
            for (ClientProperty propertyValue : value.asComplex()) {
                complexProperties.add(this.getProperty(propertyValue));
            }
            ComplexValue lcValueResource = new ComplexValue();
            lcValueResource.getValue().addAll(complexProperties);
            this.annotations((ClientAnnotatable)value.asComplex(), (Annotatable)lcValueResource);
            this.links((ClientLinked)value.asComplex(), (Linked)lcValueResource);
            lcValueResource.setTypeName(value.asComplex().getTypeName());
            valueResource = lcValueResource;
        } else if (value.isCollection()) {
            ClientCollectionValue _value = value.asCollection();
            ComplexValue lcValueResource = new ArrayList();
            for (ClientValue collectionValue : _value) {
                lcValueResource.add(this.getValue(collectionValue));
            }
            valueResource = lcValueResource;
        }
        return valueResource;
    }

    private void odataAnnotations(Annotatable annotatable, ClientAnnotatable odataAnnotatable) {
        for (Annotation annotation : annotatable.getAnnotations()) {
            EdmTypeInfo typeInfo;
            EdmTerm term;
            FullQualifiedName fqn = null;
            if (this.client instanceof EdmEnabledODataClient && (term = ((EdmEnabledODataClient)this.client).getCachedEdm().getTerm(new FullQualifiedName(annotation.getTerm()))) != null) {
                fqn = term.getType().getFullQualifiedName();
            }
            if (fqn == null && annotation.getType() != null && (typeInfo = new EdmTypeInfo.Builder().setTypeExpression(annotation.getType()).build()).isPrimitiveType()) {
                fqn = typeInfo.getPrimitiveTypeKind().getFullQualifiedName();
            }
            ClientAnnotationImpl odataAnnotation = new ClientAnnotationImpl(annotation.getTerm(), this.getODataValue(fqn, (Valuable)annotation, null, null));
            odataAnnotatable.getAnnotations().add(odataAnnotation);
        }
    }

    public ClientEntitySet getODataEntitySet(ResWrap<EntityCollection> resource) {
        ClientEntitySet entitySet;
        if (LOG.isDebugEnabled()) {
            StringWriter writer = new StringWriter();
            try {
                this.client.getSerializer(ContentType.JSON).write((Writer)writer, resource.getPayload());
            }
            catch (ODataSerializerException e) {
                LOG.debug("EntitySet -> ODataEntitySet:\n{}", (Object)writer.toString());
            }
            writer.flush();
            LOG.debug("EntitySet -> ODataEntitySet:\n{}", (Object)writer.toString());
        }
        URI base = resource.getContextURL() == null ? ((EntityCollection)resource.getPayload()).getBaseURI() : ContextURLParser.parse(resource.getContextURL()).getServiceRoot();
        URI next = ((EntityCollection)resource.getPayload()).getNext();
        ClientEntitySet clientEntitySet = entitySet = next == null ? this.client.getObjectFactory().newEntitySet() : this.client.getObjectFactory().newEntitySet(URIUtils.getURI(base, next.toASCIIString()));
        if (((EntityCollection)resource.getPayload()).getCount() != null) {
            entitySet.setCount(((EntityCollection)resource.getPayload()).getCount().intValue());
        }
        for (Operation op : ((EntityCollection)resource.getPayload()).getOperations()) {
            ClientOperation operation = new ClientOperation();
            operation.setTarget(URIUtils.getURI(base, op.getTarget()));
            operation.setTitle(op.getTitle());
            operation.setMetadataAnchor(op.getMetadataAnchor());
            entitySet.getOperations().add(operation);
        }
        for (Entity entityResource : ((EntityCollection)resource.getPayload()).getEntities()) {
            this.add(entitySet, this.getODataEntity((ResWrap<Entity>)new ResWrap(resource.getContextURL(), resource.getMetadataETag(), (Object)entityResource)));
        }
        if (((EntityCollection)resource.getPayload()).getDeltaLink() != null) {
            entitySet.setDeltaLink(URIUtils.getURI(base, ((EntityCollection)resource.getPayload()).getDeltaLink()));
        }
        this.odataAnnotations((Annotatable)resource.getPayload(), (ClientAnnotatable)entitySet);
        return entitySet;
    }

    protected void odataNavigationLinks(EdmType edmType, Linked linked, ClientLinked odataLinked, String metadataETag, URI base) {
        for (Link link : linked.getNavigationLinks()) {
            String href = link.getHref();
            String title = link.getTitle();
            Entity inlineEntity = link.getInlineEntity();
            EntityCollection inlineEntitySet = link.getInlineEntitySet();
            if (inlineEntity == null && inlineEntitySet == null) {
                EdmNavigationProperty navProp;
                ClientLinkType linkType = null;
                if (edmType instanceof EdmStructuredType && (navProp = ((EdmStructuredType)edmType).getNavigationProperty(title)) != null) {
                    ClientLinkType clientLinkType = linkType = navProp.isCollection() ? ClientLinkType.ENTITY_SET_NAVIGATION : ClientLinkType.ENTITY_NAVIGATION;
                }
                if (linkType == null) {
                    linkType = link.getType() == null ? ClientLinkType.ENTITY_NAVIGATION : ClientLinkType.fromString((String)link.getRel(), (String)link.getType());
                }
                odataLinked.addLink(linkType == ClientLinkType.ENTITY_NAVIGATION ? this.client.getObjectFactory().newEntityNavigationLink(title, URIUtils.getURI(base, href)) : this.client.getObjectFactory().newEntitySetNavigationLink(title, URIUtils.getURI(base, href)));
                continue;
            }
            if (inlineEntity != null) {
                odataLinked.addLink((ClientLink)this.createODataInlineEntity(inlineEntity, URIUtils.getURI(base, href), title, metadataETag));
                continue;
            }
            odataLinked.addLink((ClientLink)this.createODataInlineEntitySet(inlineEntitySet, href == null ? null : URIUtils.getURI(base, href), title, metadataETag));
        }
        for (Link link : odataLinked.getNavigationLinks()) {
            if (link instanceof ClientInlineEntity || link instanceof ClientInlineEntitySet) continue;
            this.odataAnnotations((Annotatable)linked.getNavigationLink(link.getName()), (ClientAnnotatable)link);
        }
    }

    private ClientInlineEntity createODataInlineEntity(Entity inlineEntity, URI uri, String title, String metadataETag) {
        return new ClientInlineEntity(uri, ClientLinkType.ENTITY_NAVIGATION, title, this.getODataEntity((ResWrap<Entity>)new ResWrap(inlineEntity.getBaseURI() == null ? null : inlineEntity.getBaseURI(), metadataETag, (Object)inlineEntity)));
    }

    private ClientInlineEntitySet createODataInlineEntitySet(EntityCollection inlineEntitySet, URI uri, String title, String metadataETag) {
        return new ClientInlineEntitySet(uri, ClientLinkType.ENTITY_SET_NAVIGATION, title, this.getODataEntitySet((ResWrap<EntityCollection>)new ResWrap(inlineEntitySet.getBaseURI() == null ? null : inlineEntitySet.getBaseURI(), metadataETag, (Object)inlineEntitySet)));
    }

    private EdmType findEntityType(String entitySetOrSingletonOrType, EdmEntityContainer container) {
        String[] splitted;
        EdmEntityType type = null;
        String firstToken = StringUtils.substringBefore((String)entitySetOrSingletonOrType, (String)"/");
        EdmEntitySet bindingTarget = container.getEntitySet(firstToken);
        if (bindingTarget == null) {
            bindingTarget = container.getSingleton(firstToken);
        }
        if (bindingTarget != null) {
            type = bindingTarget.getEntityType();
        }
        if (entitySetOrSingletonOrType.indexOf(47) != -1 && (splitted = entitySetOrSingletonOrType.split("/")).length > 1) {
            for (int i = 1; i < splitted.length && type != null; ++i) {
                EdmNavigationProperty navProp = ((EdmStructuredType)type).getNavigationProperty(splitted[i]);
                if (navProp == null) {
                    EdmProperty property = ((EdmStructuredType)type).getStructuralProperty(splitted[i]);
                    if (property != null) {
                        type = property.getType();
                        continue;
                    }
                    type = null;
                    continue;
                }
                type = navProp.getType();
            }
        }
        return type;
    }

    private EdmType findType(String candidateTypeName, ContextURL contextURL, String metadataETag) {
        EdmEntityType type = null;
        if (this.client instanceof EdmEnabledODataClient) {
            Edm edm = ((EdmEnabledODataClient)this.client).getEdm(metadataETag);
            if (StringUtils.isNotBlank((CharSequence)candidateTypeName)) {
                type = edm.getEntityType(new FullQualifiedName(candidateTypeName));
            }
            if (type == null && contextURL != null) {
                if (contextURL.getDerivedEntity() == null) {
                    for (EdmSchema schema : edm.getSchemas()) {
                        EdmType structuredType;
                        EdmEntityContainer container = schema.getEntityContainer();
                        if (container == null || (structuredType = this.findEntityType(contextURL.getEntitySetOrSingletonOrType(), container)) == null) continue;
                        if (contextURL.getNavOrPropertyPath() == null) {
                            type = structuredType;
                            continue;
                        }
                        EdmNavigationProperty navProp = ((EdmStructuredType)structuredType).getNavigationProperty(contextURL.getNavOrPropertyPath());
                        type = navProp == null ? structuredType : navProp.getType();
                    }
                    if (type == null) {
                        type = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(contextURL.getEntitySetOrSingletonOrType()).build().getType();
                    }
                } else {
                    type = edm.getEntityType(new FullQualifiedName(contextURL.getDerivedEntity()));
                }
            }
        }
        return type;
    }

    private ClientLink createLinkFromNavigationProperty(Property property, String propertyTypeName, Integer count) {
        if (property.isCollection()) {
            EntityCollection inlineEntitySet = new EntityCollection();
            for (Object inlined : property.asCollection()) {
                Entity inlineEntity = new Entity();
                if (inlined instanceof ComplexValue && ((ComplexValue)inlined).getTypeName() != null) {
                    inlineEntity.setType(((ComplexValue)inlined).getTypeName());
                } else {
                    inlineEntity.setType(propertyTypeName);
                }
                inlineEntity.getProperties().addAll(((ComplexValue)inlined).getValue());
                this.copyAnnotations(inlineEntity, (ComplexValue)inlined);
                inlineEntitySet.getEntities().add(inlineEntity);
            }
            if (count != null) {
                inlineEntitySet.setCount(count);
            }
            return this.createODataInlineEntitySet(inlineEntitySet, null, property.getName(), null);
        }
        Entity inlineEntity = new Entity();
        inlineEntity.setType(propertyTypeName);
        inlineEntity.getProperties().addAll(property.asComplex().getValue());
        this.copyAnnotations(inlineEntity, property.asComplex());
        return this.createODataInlineEntity(inlineEntity, null, property.getName(), null);
    }

    private void copyAnnotations(Entity inlineEntity, ComplexValue complex) {
        for (Annotation annotation : complex.getAnnotations()) {
            if (annotation.getTerm().equals("@odata.type".substring(1))) {
                inlineEntity.setType((String)annotation.asPrimitive());
                continue;
            }
            if (annotation.getTerm().equals("@odata.id".substring(1))) {
                inlineEntity.setId(URI.create((String)annotation.asPrimitive()));
                continue;
            }
            if (!annotation.getTerm().equals("@odata.etag".substring(1))) continue;
            inlineEntity.setETag((String)annotation.asPrimitive());
        }
    }

    private ClientLink createLinkFromEmptyNavigationProperty(String propertyName, Integer count) {
        EntityCollection inlineEntitySet = new EntityCollection();
        if (count != null) {
            inlineEntitySet.setCount(count);
        }
        return this.createODataInlineEntitySet(inlineEntitySet, null, propertyName, null);
    }

    public ClientEntity getODataEntity(ResWrap<Entity> resource) {
        ClientEntity entity;
        if (LOG.isDebugEnabled()) {
            StringWriter writer = new StringWriter();
            try {
                this.client.getSerializer(ContentType.JSON).write((Writer)writer, resource.getPayload());
            }
            catch (ODataSerializerException e) {
                LOG.debug("EntityResource -> ODataEntity:\n{}", (Object)writer.toString());
            }
            writer.flush();
            LOG.debug("EntityResource -> ODataEntity:\n{}", (Object)writer.toString());
        }
        ContextURL contextURL = ContextURLParser.parse(resource.getContextURL());
        URI base = resource.getContextURL() == null ? ((Entity)resource.getPayload()).getBaseURI() : contextURL.getServiceRoot();
        EdmType edmType = this.findType(((Entity)resource.getPayload()).getType(), contextURL, resource.getMetadataETag());
        FullQualifiedName typeName = null;
        if (((Entity)resource.getPayload()).getType() == null) {
            if (edmType != null) {
                typeName = edmType.getFullQualifiedName();
            }
        } else {
            typeName = new FullQualifiedName(((Entity)resource.getPayload()).getType());
        }
        ClientEntity clientEntity = entity = ((Entity)resource.getPayload()).getSelfLink() == null ? this.client.getObjectFactory().newEntity(typeName) : this.client.getObjectFactory().newEntity(typeName, URIUtils.getURI(base, ((Entity)resource.getPayload()).getSelfLink().getHref()));
        if (StringUtils.isNotBlank((CharSequence)((Entity)resource.getPayload()).getETag())) {
            entity.setETag(((Entity)resource.getPayload()).getETag());
        }
        if (((Entity)resource.getPayload()).getEditLink() != null) {
            entity.setEditLink(URIUtils.getURI(base, ((Entity)resource.getPayload()).getEditLink().getHref()));
        }
        for (Link link : ((Entity)resource.getPayload()).getAssociationLinks()) {
            entity.addLink(this.client.getObjectFactory().newAssociationLink(link.getTitle(), URIUtils.getURI(base, link.getHref())));
        }
        this.odataNavigationLinks(edmType, (Linked)resource.getPayload(), (ClientLinked)entity, resource.getMetadataETag(), base);
        for (Link link : ((Entity)resource.getPayload()).getMediaEditLinks()) {
            if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                entity.addLink(this.client.getObjectFactory().newMediaReadLink(link.getTitle(), URIUtils.getURI(base, link.getHref()), link.getType(), link.getMediaETag()));
                continue;
            }
            entity.addLink(this.client.getObjectFactory().newMediaEditLink(link.getTitle(), URIUtils.getURI(base, link.getHref()), link.getType(), link.getMediaETag()));
        }
        for (Operation op : ((Entity)resource.getPayload()).getOperations()) {
            ClientOperation clientOperation = new ClientOperation();
            clientOperation.setTarget(URIUtils.getURI(base, op.getTarget()));
            clientOperation.setTitle(op.getTitle());
            clientOperation.setMetadataAnchor(op.getMetadataAnchor());
            entity.getOperations().add(clientOperation);
        }
        if (((Entity)resource.getPayload()).isMediaEntity()) {
            entity.setMediaEntity(true);
            entity.setMediaContentSource(URIUtils.getURI(base, ((Entity)resource.getPayload()).getMediaContentSource()));
            entity.setMediaContentType(((Entity)resource.getPayload()).getMediaContentType());
            entity.setMediaETag(((Entity)resource.getPayload()).getMediaETag());
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Property property : ((Entity)resource.getPayload()).getProperties()) {
            EdmType propertyType = null;
            if (edmType instanceof EdmEntityType) {
                EdmElement edmProperty = ((EdmEntityType)edmType).getProperty(property.getName());
                if (edmProperty != null) {
                    propertyType = edmProperty.getType();
                    if (edmProperty instanceof EdmNavigationProperty && !property.isNull()) {
                        String propertyTypeName = propertyType.getFullQualifiedName().getFullQualifiedNameAsString();
                        entity.addLink(this.createLinkFromNavigationProperty(property, propertyTypeName, (Integer)countMap.remove(property.getName())));
                        continue;
                    }
                } else {
                    String navigationName;
                    int idx = property.getName().indexOf("@odata.count");
                    if (idx != -1 && (edmProperty = ((EdmEntityType)edmType).getProperty(navigationName = property.getName().substring(0, idx))) != null && edmProperty instanceof EdmNavigationProperty) {
                        ClientLink link = entity.getNavigationLink(navigationName);
                        if (link == null) {
                            countMap.put(navigationName, (Integer)property.getValue());
                        } else {
                            link.asInlineEntitySet().getEntitySet().setCount(((Integer)property.getValue()).intValue());
                        }
                    }
                }
            }
            this.add(entity, this.getODataProperty(propertyType, property));
        }
        if (!countMap.isEmpty()) {
            for (Map.Entry entry : countMap.entrySet()) {
                entity.addLink(this.createLinkFromEmptyNavigationProperty((String)entry.getKey(), (Integer)entry.getValue()));
            }
        }
        entity.setId(((Entity)resource.getPayload()).getId());
        this.odataAnnotations((Annotatable)resource.getPayload(), (ClientAnnotatable)entity);
        return entity;
    }

    public ClientProperty getODataProperty(ResWrap<Property> resource) {
        Property payload = (Property)resource.getPayload();
        EdmTypeInfo typeInfo = this.buildTypeInfo(ContextURLParser.parse(resource.getContextURL()), resource.getMetadataETag(), payload.getName(), payload.getType());
        ClientPropertyImpl property = new ClientPropertyImpl(payload.getName(), this.getODataValue(typeInfo == null ? null : typeInfo.getFullQualifiedName(), (Valuable)payload, resource.getContextURL(), resource.getMetadataETag()));
        this.odataAnnotations((Annotatable)payload, (ClientAnnotatable)property);
        for (Operation op : ((Property)resource.getPayload()).getOperations()) {
            ClientOperation operation = new ClientOperation();
            operation.setTarget(op.getTarget());
            operation.setTitle(op.getTitle());
            operation.setMetadataAnchor(op.getMetadataAnchor());
            property.getOperations().add(operation);
        }
        return property;
    }

    private EdmTypeInfo buildTypeInfo(ContextURL contextURL, String metadataETag, String propertyName, String propertyType) {
        EdmProperty edmProperty;
        FullQualifiedName typeName = null;
        EdmType type = this.findType(null, contextURL, metadataETag);
        if (type instanceof EdmStructuredType && (edmProperty = ((EdmStructuredType)type).getStructuralProperty(propertyName)) != null) {
            typeName = edmProperty.getType().getFullQualifiedName();
        }
        if (typeName == null && type != null) {
            typeName = type.getFullQualifiedName();
        }
        return this.buildTypeInfo(typeName, propertyType);
    }

    private EdmTypeInfo buildTypeInfo(FullQualifiedName typeName, String propertyType) {
        EdmTypeInfo typeInfo = null;
        if (typeName == null) {
            if (propertyType != null) {
                typeInfo = new EdmTypeInfo.Builder().setTypeExpression(propertyType).build();
            }
        } else {
            typeInfo = propertyType == null || propertyType.equals(EdmPrimitiveTypeKind.String.getFullQualifiedName().toString()) ? new EdmTypeInfo.Builder().setTypeExpression(typeName.toString()).build() : (this.isPrimiteveType(typeName) ? new EdmTypeInfo.Builder().setTypeExpression(typeName.toString()).build() : new EdmTypeInfo.Builder().setTypeExpression(propertyType).build());
        }
        return typeInfo;
    }

    private boolean isPrimiteveType(FullQualifiedName typeName) {
        try {
            return EdmPrimitiveTypeKind.valueOfFQN((FullQualifiedName)typeName) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected ClientProperty getODataProperty(EdmType type, Property resource) {
        EdmTypeInfo typeInfo = this.buildTypeInfo(type == null ? null : type.getFullQualifiedName(), resource.getType());
        ClientPropertyImpl property = new ClientPropertyImpl(resource.getName(), this.getODataValue(typeInfo == null ? null : typeInfo.getFullQualifiedName(), (Valuable)resource, null, null));
        this.odataAnnotations((Annotatable)resource, (ClientAnnotatable)property);
        return property;
    }

    protected ClientValue getODataValue(FullQualifiedName type, Valuable valuable, URI contextURL, String metadataETag) {
        if (this.client instanceof EdmEnabledODataClient && type != null) {
            EdmEnumType edmType = ((EdmEnabledODataClient)this.client).getEdm(metadataETag).getEnumType(type);
            if (!valuable.isCollection() && valuable.isPrimitive() && edmType != null) {
                valuable.setValue(ValueType.ENUM, valuable.asPrimitive());
            }
        }
        ClientCollectionValue value = null;
        if (valuable.isCollection()) {
            value = this.client.getObjectFactory().newCollectionValue(type == null ? null : "Collection(" + type.toString() + ")");
            for (Object _value : valuable.asCollection()) {
                Property fake = new Property();
                fake.setValue(valuable.getValueType().getBaseType(), _value);
                String typeName = null;
                if (_value instanceof ComplexValue) {
                    typeName = ((ComplexValue)_value).getTypeName();
                    type = typeName == null ? type : new FullQualifiedName(typeName);
                }
                value.asCollection().add(this.getODataValue(type, (Valuable)fake, contextURL, metadataETag));
            }
        } else if (valuable.isEnum()) {
            value = this.client.getObjectFactory().newEnumValue(type == null ? null : type.toString(), valuable.asEnum().toString());
        } else if (valuable.isComplex()) {
            ClientComplexValue lcValue = this.client.getObjectFactory().newComplexValue(type == null ? null : type.toString());
            EdmComplexType edmType = null;
            if (this.client instanceof EdmEnabledODataClient && type != null) {
                edmType = ((EdmEnabledODataClient)this.client).getEdm(metadataETag).getComplexType(type);
            }
            for (Property property : valuable.asComplex().getValue()) {
                EdmElement edmProp;
                EdmType edmPropertyType = null;
                if (edmType != null && (edmProp = edmType.getProperty(property.getName())) != null) {
                    edmPropertyType = edmProp.getType();
                }
                lcValue.add(this.getODataProperty(edmPropertyType, property));
            }
            this.odataNavigationLinks((EdmType)edmType, (Linked)valuable.asComplex(), (ClientLinked)lcValue, metadataETag, contextURL);
            this.odataAnnotations((Annotatable)valuable.asComplex(), (ClientAnnotatable)lcValue);
            value = lcValue;
        } else if (valuable.isGeospatial()) {
            value = this.client.getObjectFactory().newPrimitiveValueBuilder().setValue((Object)valuable.asGeospatial()).setType(type == null || EdmPrimitiveTypeKind.Geography.getFullQualifiedName().equals((Object)type) || EdmPrimitiveTypeKind.Geometry.getFullQualifiedName().equals((Object)type) ? valuable.asGeospatial().getEdmPrimitiveTypeKind() : EdmPrimitiveTypeKind.valueOfFQN((String)type.toString())).build();
        } else if (valuable.isPrimitive() || valuable.getValueType() == null) {
            Edm edm = null;
            if (this.client instanceof EdmEnabledODataClient && type != null) {
                edm = ((EdmEnabledODataClient)this.client).getEdm(metadataETag);
            }
            if (edm != null && edm.getComplexType(type) != null) {
                ClientComplexValue cValue = this.client.getObjectFactory().newComplexValue(type.toString());
                value = cValue;
            } else {
                if (type != null && !EdmPrimitiveTypeKind.String.getFullQualifiedName().equals((Object)type) && "Edm".equals(type.getNamespace()) && valuable.asPrimitive() instanceof String) {
                    EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)type.getName()));
                    Class returnType = primitiveType.getDefaultType().isAssignableFrom(Calendar.class) ? Timestamp.class : primitiveType.getDefaultType();
                    try {
                        valuable.setValue(valuable.getValueType(), primitiveType.valueOfString(valuable.asPrimitive().toString(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null, returnType));
                    }
                    catch (EdmPrimitiveTypeException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                value = this.client.getObjectFactory().newPrimitiveValueBuilder().setValue(valuable.asPrimitive()).setType(type == null || !"Edm".equals(type.getNamespace()) ? null : EdmPrimitiveTypeKind.valueOfFQN((String)type.toString())).build();
            }
        } else if (valuable.isComplex()) {
            ClientComplexValue cValue = this.client.getObjectFactory().newComplexValue(type == null ? null : type.toString());
            if (!valuable.isNull()) {
                EdmComplexType edmType = null;
                if (this.client instanceof EdmEnabledODataClient && type != null) {
                    edmType = ((EdmEnabledODataClient)this.client).getEdm(metadataETag).getComplexType(type);
                }
                for (Property property : valuable.asComplex().getValue()) {
                    EdmElement edmProp;
                    EdmType edmPropertyType = null;
                    if (edmType != null && (edmProp = edmType.getProperty(property.getName())) != null) {
                        edmPropertyType = edmProp.getType();
                    }
                    cValue.add(this.getODataProperty(edmPropertyType, property));
                }
            }
            value = cValue;
        }
        return value;
    }

    public ClientDelta getODataDelta(ResWrap<Delta> resource) {
        ClientItem impl;
        ClientDelta delta;
        URI base = resource.getContextURL() == null ? ((Delta)resource.getPayload()).getBaseURI() : ContextURLParser.parse(resource.getContextURL()).getServiceRoot();
        URI next = ((Delta)resource.getPayload()).getNext();
        ClientDelta clientDelta = delta = next == null ? this.client.getObjectFactory().newDelta() : this.client.getObjectFactory().newDelta(URIUtils.getURI(base, next.toASCIIString()));
        if (((Delta)resource.getPayload()).getCount() != null) {
            delta.setCount(((Delta)resource.getPayload()).getCount().intValue());
        }
        if (((Delta)resource.getPayload()).getDeltaLink() != null) {
            delta.setDeltaLink(URIUtils.getURI(base, ((Delta)resource.getPayload()).getDeltaLink()));
        }
        for (Entity entityResource : ((Delta)resource.getPayload()).getEntities()) {
            this.add((ClientEntitySet)delta, this.getODataEntity((ResWrap<Entity>)new ResWrap(resource.getContextURL(), resource.getMetadataETag(), (Object)entityResource)));
        }
        for (DeletedEntity deletedEntity : ((Delta)resource.getPayload()).getDeletedEntities()) {
            impl = new ClientDeletedEntityImpl();
            impl.setId(URIUtils.getURI(base, deletedEntity.getId()));
            impl.setReason(ClientDeletedEntity.Reason.valueOf((String)deletedEntity.getReason().name()));
            delta.getDeletedEntities().add(impl);
        }
        this.odataAnnotations((Annotatable)resource.getPayload(), (ClientAnnotatable)delta);
        for (DeltaLink link : ((Delta)resource.getPayload()).getAddedLinks()) {
            impl = new ClientDeltaLinkImpl();
            impl.setRelationship(link.getRelationship());
            impl.setSource(URIUtils.getURI(base, link.getSource()));
            impl.setTarget(URIUtils.getURI(base, link.getTarget()));
            this.odataAnnotations((Annotatable)link, (ClientAnnotatable)impl);
            delta.getAddedLinks().add(impl);
        }
        for (DeltaLink link : ((Delta)resource.getPayload()).getDeletedLinks()) {
            impl = new ClientDeltaLinkImpl();
            impl.setRelationship(link.getRelationship());
            impl.setSource(URIUtils.getURI(base, link.getSource()));
            impl.setTarget(URIUtils.getURI(base, link.getTarget()));
            this.odataAnnotations((Annotatable)link, (ClientAnnotatable)impl);
            delta.getDeletedLinks().add(impl);
        }
        return delta;
    }
}

