/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.server.core.uri.parser.search.SearchQueryToken;
import org.apache.olingo.server.core.uri.parser.search.SearchTokenizerException;

public class SearchTokenizer {
    public List<SearchQueryToken> tokenize(String searchQuery) throws SearchTokenizerException {
        if (searchQuery.contains("%28") || searchQuery.contains("%29") || searchQuery.contains("%22")) {
            throw new SearchTokenizerException("Invalid Token in Query string '", SearchTokenizerException.MessageKeys.NOT_EXPECTED_TOKEN, searchQuery);
        }
        char[] chars = searchQuery.trim().toCharArray();
        State state = new SearchExpressionState();
        ArrayList<SearchQueryToken> states = new ArrayList<SearchQueryToken>();
        for (char aChar : chars) {
            State next = state.nextChar(aChar);
            if (state.isFinished()) {
                states.add(state);
            }
            state = next;
        }
        if (!state.close().isFinished()) {
            throw new SearchTokenizerException("Last parsed state '" + state.toString() + "' is not finished.", SearchTokenizerException.MessageKeys.NOT_FINISHED_QUERY, state.getTokenName());
        }
        states.add(state);
        return states;
    }

    private class RwsState
    extends State {
        private RwsState() {
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (RwsState.isWhitespace(c)) {
                return this.allowed(c);
            }
            if (c == 'O') {
                return new OrState(c);
            }
            if (c == 'A') {
                return new AndState(c);
            }
            return new SearchExpressionState().init(c);
        }
    }

    private class BeforePhraseOrWordRwsState
    extends State {
        private BeforePhraseOrWordRwsState() {
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (BeforePhraseOrWordRwsState.isWhitespace(c)) {
                return this.allowed(c);
            }
            if (c == '\"') {
                return new SearchPhraseState(c);
            }
            return new SearchWordState(c);
        }
    }

    private class BeforeSearchExpressionRwsState
    extends State {
        private BeforeSearchExpressionRwsState() {
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (BeforeSearchExpressionRwsState.isWhitespace(c)) {
                return this.allowed(c);
            }
            return new SearchExpressionState().init(c);
        }
    }

    private class OrState
    extends LiteralState {
        public OrState(char c) throws SearchTokenizerException {
            super(SearchQueryToken.Token.OR, c);
            if (c != 'O') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (this.literal.length() == 1 && c == 'R') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && OrState.isWhitespace(c)) {
                this.finish();
                return new BeforeSearchExpressionRwsState();
            }
            if (OrState.isWhitespace(c)) {
                this.changeToken(SearchQueryToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new SearchWordState(this);
        }

        @Override
        public State close() throws SearchTokenizerException {
            if (SearchQueryToken.Token.OR.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(SearchQueryToken.Token.WORD).finish();
        }
    }

    private class AndState
    extends LiteralState {
        public AndState(char c) throws SearchTokenizerException {
            super(SearchQueryToken.Token.AND, c);
            if (c != 'A') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (this.literal.length() == 1 && c == 'N') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && c == 'D') {
                return this.allowed(c);
            }
            if (this.literal.length() == 3 && AndState.isWhitespace(c)) {
                this.finish();
                return new BeforeSearchExpressionRwsState();
            }
            if (AndState.isWhitespace(c)) {
                this.changeToken(SearchQueryToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new SearchWordState(this);
        }

        @Override
        public State close() throws SearchTokenizerException {
            if (SearchQueryToken.Token.AND.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(SearchQueryToken.Token.WORD).finish();
        }
    }

    private class NotState
    extends LiteralState {
        public NotState(char c) throws SearchTokenizerException {
            super(SearchQueryToken.Token.NOT, c);
            if (c != 'N') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (this.literal.length() == 1 && c == 'O') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && c == 'T') {
                return this.allowed(c);
            }
            if (this.literal.length() == 3 && NotState.isWhitespace(c)) {
                this.finish();
                return new BeforePhraseOrWordRwsState();
            }
            if (NotState.isWhitespace(c)) {
                this.changeToken(SearchQueryToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new SearchWordState(this);
        }

        @Override
        public State close() throws SearchTokenizerException {
            if (SearchQueryToken.Token.NOT.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(SearchQueryToken.Token.WORD).finish();
        }
    }

    private class CloseState
    extends State {
        public CloseState() {
            super(SearchQueryToken.Token.CLOSE, true);
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            return new SearchExpressionState().init(c);
        }
    }

    private class OpenState
    extends State {
        public OpenState() {
            super(SearchQueryToken.Token.OPEN, true);
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            this.finish();
            if (OpenState.isWhitespace(c)) {
                return this.forbidden(c);
            }
            return new SearchExpressionState().init(c);
        }
    }

    private class SearchPhraseState
    extends LiteralState {
        private boolean closed;
        private boolean escaped;

        public SearchPhraseState(char c) throws SearchTokenizerException {
            super(SearchQueryToken.Token.PHRASE, c);
            this.closed = false;
            this.escaped = false;
            if (c != '\"') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (this.closed) {
                this.finish();
                if (c == ')') {
                    return new CloseState();
                }
                if (SearchPhraseState.isWhitespace(c)) {
                    return new RwsState();
                }
            } else {
                if (this.escaped) {
                    this.escaped = false;
                    if (c == '\"' || c == '\\') {
                        return this.allowed(c);
                    }
                    return this.forbidden(c);
                }
                if (c == '\\') {
                    this.escaped = true;
                    return this;
                }
                if (SearchPhraseState.isAllowedPhrase(c)) {
                    return this.allowed(c);
                }
                if (SearchPhraseState.isWhitespace(c)) {
                    return this.allowed(c);
                }
                if (c == '\"') {
                    if (this.literal.length() == 1) {
                        return this.invalid();
                    }
                    this.closed = true;
                    return this.allowed(c);
                }
            }
            return this.forbidden(c);
        }

        @Override
        public State close() throws SearchTokenizerException {
            if (this.closed) {
                return this.finish();
            }
            return this.invalid();
        }
    }

    private class SearchWordState
    extends LiteralState {
        public SearchWordState(char c) throws SearchTokenizerException {
            super(SearchQueryToken.Token.WORD, c);
            if (!SearchWordState.isAllowedWord(c)) {
                this.forbidden(c);
            }
        }

        public SearchWordState(State toConsume) throws SearchTokenizerException {
            super(SearchQueryToken.Token.WORD, toConsume.getLiteral());
            for (int i = 0; i < this.literal.length(); ++i) {
                if (SearchWordState.isAllowedWord(this.literal.charAt(i))) continue;
                this.forbidden(this.literal.charAt(i));
            }
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (SearchWordState.isAllowedWord(c) || '0' <= c && c <= '9' || c == ',' || c == '.' || c == '-') {
                return this.allowed(c);
            }
            if (c == ')') {
                this.finish();
                return new CloseState();
            }
            if (SearchWordState.isWhitespace(c)) {
                this.finish();
                return new RwsState();
            }
            return this.forbidden(c);
        }

        @Override
        public State finish() {
            String tmpLiteral = this.literal.toString();
            if (tmpLiteral.length() == 3) {
                if (SearchQueryToken.Token.AND.name().equals(tmpLiteral)) {
                    return this.finishAs(SearchQueryToken.Token.AND);
                }
                if (SearchQueryToken.Token.NOT.name().equals(tmpLiteral)) {
                    return this.finishAs(SearchQueryToken.Token.NOT);
                }
            } else if (tmpLiteral.length() == 2 && SearchQueryToken.Token.OR.name().equals(tmpLiteral)) {
                return this.finishAs(SearchQueryToken.Token.OR);
            }
            return super.finish();
        }

        @Override
        public State close() {
            return this.finish();
        }
    }

    private class SearchTermState
    extends LiteralState {
        private SearchTermState() {
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (c == 'N') {
                return new NotState(c);
            }
            if (c == '\"') {
                return new SearchPhraseState(c);
            }
            if (SearchTermState.isAllowedWord(c)) {
                return new SearchWordState(c);
            }
            return this.forbidden(c);
        }

        @Override
        public State init(char c) throws SearchTokenizerException {
            return this.nextChar(c);
        }
    }

    private class SearchExpressionState
    extends LiteralState {
        private SearchExpressionState() {
        }

        @Override
        public State nextChar(char c) throws SearchTokenizerException {
            if (c == '(') {
                return new OpenState();
            }
            if (SearchExpressionState.isWhitespace(c)) {
                return new RwsState();
            }
            if (c == ')') {
                return new CloseState();
            }
            return new SearchTermState().init(c);
        }

        @Override
        public State init(char c) throws SearchTokenizerException {
            return this.nextChar(c);
        }
    }

    private static abstract class LiteralState
    extends State {
        protected final StringBuilder literal = new StringBuilder();

        public LiteralState() {
        }

        public LiteralState(SearchQueryToken.Token t, char c) throws SearchTokenizerException {
            super(t);
            this.init(c);
        }

        public LiteralState(SearchQueryToken.Token t, String initLiteral) {
            super(t);
            this.literal.append(initLiteral);
        }

        @Override
        public State allowed(char c) {
            this.literal.append(c);
            return this;
        }

        @Override
        public String getLiteral() {
            return this.literal.toString();
        }

        public State init(char c) throws SearchTokenizerException {
            if (this.isFinished()) {
                throw new SearchTokenizerException(this.toString() + " is already finished.", SearchTokenizerException.MessageKeys.ALREADY_FINISHED, this.getTokenName());
            }
            this.literal.append(c);
            return this;
        }
    }

    private static abstract class State
    implements SearchQueryToken {
        private SearchQueryToken.Token token = null;
        private boolean finished = false;
        protected static final char QUOTATION_MARK = '\"';
        protected static final char PHRASE_ESCAPE_CHAR = '\\';
        protected static final char CHAR_N = 'N';
        protected static final char CHAR_O = 'O';
        protected static final char CHAR_T = 'T';
        protected static final char CHAR_A = 'A';
        protected static final char CHAR_D = 'D';
        protected static final char CHAR_R = 'R';
        protected static final char CHAR_CLOSE = ')';
        protected static final char CHAR_OPEN = '(';
        protected static final char CHAR_COMMA = ',';
        protected static final char CHAR_DOT = '.';
        protected static final char CHAR_HYPEN = '-';

        public State() {
        }

        public State(SearchQueryToken.Token t) {
            this.token = t;
        }

        public State(SearchQueryToken.Token t, boolean finished) {
            this(t);
            this.finished = finished;
        }

        protected abstract State nextChar(char var1) throws SearchTokenizerException;

        public State allowed(char c) {
            return this;
        }

        public State forbidden(char c) throws SearchTokenizerException {
            throw new SearchTokenizerException("Forbidden character in state " + (Object)((Object)this.token) + "->" + c, SearchTokenizerException.MessageKeys.FORBIDDEN_CHARACTER, "" + c);
        }

        public State invalid() throws SearchTokenizerException {
            throw new SearchTokenizerException("Token " + (Object)((Object)this.token) + " is in invalid state.", SearchTokenizerException.MessageKeys.INVALID_TOKEN_STATE, new String[0]);
        }

        public State finish() {
            this.finished = true;
            return this;
        }

        public State finishAs(SearchQueryToken.Token token) {
            this.finished = true;
            return this.changeToken(token);
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public SearchQueryToken.Token getToken() {
            return this.token;
        }

        public String getTokenName() {
            if (this.token == null) {
                return "NULL";
            }
            return this.token.name();
        }

        public State close() throws SearchTokenizerException {
            return this;
        }

        protected State changeToken(SearchQueryToken.Token token) {
            this.token = token;
            return this;
        }

        static boolean isAllowedWord(char character) {
            return Character.isUnicodeIdentifierStart(character) || 20 == Character.getType(character) || 9 == Character.getType(character) || 24 == Character.getType(character) && character != ';' && character != '\"';
        }

        static boolean isAllowedPhrase(char character) {
            return State.isQCharUnescaped(character) || character == '%';
        }

        private static boolean isQCharUnescaped(char character) {
            return State.isUnreserved(character) || State.isOtherDelims(character) || character == ':' || character == '@' || character == '/' || character == '$' || character == '\'' || character == '=';
        }

        private static boolean isOtherDelims(char character) {
            return character == '!' || character == '(' || character == ')' || character == '*' || character == '+' || character == ',' || character == ';';
        }

        private static boolean isUnreserved(char character) {
            return State.isAlphaOrDigit(character) || character == '-' || character == '.' || character == '_' || character == '~';
        }

        private static boolean isAlphaOrDigit(char character) {
            return 'A' <= character && character <= 'Z' || 'a' <= character && character <= 'z' || '0' <= character && character <= '9';
        }

        static boolean isWhitespace(char character) {
            return character == ' ' || character == '\t';
        }

        @Override
        public String getLiteral() {
            return this.token.toString();
        }

        public String toString() {
            return (Object)((Object)this.token) + "=>{" + this.getLiteral() + "}";
        }
    }
}

