/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.domain;

import java.net.URI;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientDelta;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientEntitySet;
import org.apache.olingo.client.api.domain.ClientEnumValue;
import org.apache.olingo.client.api.domain.ClientInlineEntity;
import org.apache.olingo.client.api.domain.ClientInlineEntitySet;
import org.apache.olingo.client.api.domain.ClientLink;
import org.apache.olingo.client.api.domain.ClientLinkType;
import org.apache.olingo.client.api.domain.ClientObjectFactory;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientSingleton;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.core.domain.ClientCollectionValueImpl;
import org.apache.olingo.client.core.domain.ClientComplexValueImpl;
import org.apache.olingo.client.core.domain.ClientDeltaImpl;
import org.apache.olingo.client.core.domain.ClientEntityImpl;
import org.apache.olingo.client.core.domain.ClientEntitySetImpl;
import org.apache.olingo.client.core.domain.ClientEnumValueImpl;
import org.apache.olingo.client.core.domain.ClientPrimitiveValueImpl;
import org.apache.olingo.client.core.domain.ClientPropertyImpl;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class ClientObjectFactoryImpl
implements ClientObjectFactory {
    public ClientInlineEntitySet newDeepInsertEntitySet(String name, ClientEntitySet entitySet) {
        return new ClientInlineEntitySet(null, ClientLinkType.ENTITY_SET_NAVIGATION, name, entitySet);
    }

    public ClientInlineEntity newDeepInsertEntity(String name, ClientEntity entity) {
        return new ClientInlineEntity(null, ClientLinkType.ENTITY_NAVIGATION, name, entity);
    }

    public ClientEntitySet newEntitySet() {
        return new ClientEntitySetImpl();
    }

    public ClientEntitySet newEntitySet(URI next) {
        return new ClientEntitySetImpl(next);
    }

    public ClientEntity newEntity(FullQualifiedName typeName) {
        return new ClientEntityImpl(typeName);
    }

    public ClientEntity newEntity(FullQualifiedName typeName, URI link) {
        ClientEntityImpl result = new ClientEntityImpl(typeName);
        result.setLink(link);
        return result;
    }

    public ClientSingleton newSingleton(FullQualifiedName typeName) {
        return new ClientEntityImpl(typeName);
    }

    public ClientLink newEntityNavigationLink(String name, URI link) {
        return new ClientLink.Builder().setURI(link).setType(ClientLinkType.ENTITY_NAVIGATION).setTitle(name).build();
    }

    public ClientLink newEntitySetNavigationLink(String name, URI link) {
        return new ClientLink.Builder().setURI(link).setType(ClientLinkType.ENTITY_SET_NAVIGATION).setTitle(name).build();
    }

    public ClientLink newAssociationLink(String name, URI link) {
        return new ClientLink.Builder().setURI(link).setType(ClientLinkType.ASSOCIATION).setTitle(name).build();
    }

    public ClientLink newMediaEditLink(String name, URI link, String type, String eTag) {
        return new ClientLink.Builder().setURI(link).setEtag(eTag).setType(ClientLinkType.fromString((String)"http://docs.oasis-open.org/odata/ns/edit-media/", (String)(type == null ? "*/*" : type))).setTitle(name).build();
    }

    public ClientLink newMediaReadLink(String name, URI link, String type, String eTag) {
        return new ClientLink.Builder().setURI(link).setEtag(eTag).setType(ClientLinkType.fromString((String)"http://docs.oasis-open.org/odata/ns/mediaresource/", (String)(type == null ? "*/*" : type))).setTitle(name).build();
    }

    public ClientPrimitiveValue.Builder newPrimitiveValueBuilder() {
        return new ClientPrimitiveValueImpl.BuilderImpl();
    }

    public ClientEnumValue newEnumValue(String typeName, String value) {
        return new ClientEnumValueImpl(typeName, value);
    }

    public ClientComplexValue newComplexValue(String typeName) {
        return new ClientComplexValueImpl(typeName);
    }

    public ClientCollectionValue<ClientValue> newCollectionValue(String typeName) {
        return new ClientCollectionValueImpl<ClientValue>(typeName);
    }

    public ClientProperty newPrimitiveProperty(String name, ClientPrimitiveValue value) {
        return new ClientPropertyImpl(name, (ClientValue)value);
    }

    public ClientProperty newComplexProperty(String name, ClientComplexValue value) {
        return new ClientPropertyImpl(name, (ClientValue)value);
    }

    public ClientProperty newCollectionProperty(String name, ClientCollectionValue<? extends ClientValue> value) {
        return new ClientPropertyImpl(name, (ClientValue)value);
    }

    public ClientProperty newEnumProperty(String name, ClientEnumValue value) {
        return new ClientPropertyImpl(name, (ClientValue)value);
    }

    public ClientDelta newDelta() {
        return new ClientDeltaImpl();
    }

    public ClientDelta newDelta(URI next) {
        return new ClientDeltaImpl(next);
    }
}

