/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.model.HystrixConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMainSupport
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMainSupport.class);
    private static final String SENSITIVE_KEYS = "passphrase|password|secretkey|accesstoken|clientsecret|authorizationtoken|sasljaasconfig";
    protected final AtomicBoolean completed = new AtomicBoolean(false);
    protected volatile CamelContext camelContext;
    protected volatile ProducerTemplate camelTemplate;
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected final MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected final Properties wildcardProperties = new OrderedProperties();
    protected RoutesCollector routesCollector = new DefaultRoutesCollector();
    protected List<RoutesBuilder> routeBuilders = new ArrayList<RoutesBuilder>();
    protected String routeBuilderClasses;
    protected List<Object> configurations = new ArrayList<Object>();
    protected String configurationClasses;
    protected String propertyPlaceholderLocations;
    protected String defaultPropertyPlaceholderLocation = "classpath:application.properties;optional=true";
    protected Properties initialProperties;
    protected Properties overrideProperties;

    protected static Properties loadEnvironmentVariablesAsProperties(String[] prefixes) {
        OrderedProperties answer = new OrderedProperties();
        if (prefixes == null || prefixes.length == 0) {
            return answer;
        }
        for (String prefix : prefixes) {
            String pk = prefix.toUpperCase(Locale.US).replaceAll("[^\\w]", "-");
            String pk2 = pk.replace('-', '_');
            System.getenv().forEach((arg_0, arg_1) -> BaseMainSupport.lambda$loadEnvironmentVariablesAsProperties$0(pk, pk2, (Properties)answer, arg_0, arg_1));
        }
        return answer;
    }

    protected static String optionKey(String key) {
        key = StringHelper.replaceAll((String)key, (String)"-", (String)"");
        key = key.toLowerCase(Locale.ENGLISH);
        return key;
    }

    protected static boolean setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties, String optionPrefix, boolean failIfNotSet, boolean ignoreCase, Map<String, String> autoConfiguredProperties) throws Exception {
        org.apache.camel.util.ObjectHelper.notNull((Object)context, (String)"context");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService((Object)target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            String name = target.getClass().getSimpleName();
            if (target instanceof ExtendedCamelContext) {
                name = "ExtendedCamelContext";
            }
            configurer = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        try {
            LinkedHashMap<String, Object> backup = new LinkedHashMap<String, Object>(properties);
            rc = PropertyBindingSupport.build().withMandatory(failIfNotSet).withRemoveParameters(true).withConfigurer(configurer).withIgnoreCase(ignoreCase).bind(context, target, properties);
            for (Map.Entry entry : backup.entrySet()) {
                if (entry.getValue() == null || properties.containsKey(entry.getKey())) continue;
                String prefix = optionPrefix;
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                LOG.debug("Configured property: {}{}={} on bean: {}", new Object[]{prefix, entry.getKey(), entry.getValue(), target});
                autoConfiguredProperties.put(prefix + (String)entry.getKey(), entry.getValue().toString());
            }
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                String prefix = e.getOptionPrefix();
                if (prefix != null && !prefix.endsWith(".")) {
                    prefix = "." + prefix;
                }
                String string = key = prefix != null ? prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            if (failIfNotSet) {
                throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), optionPrefix, key, e.getCause());
            }
            LOG.debug("Error configuring property (" + key + ") with name: " + e.getPropertyName() + ") on bean: " + target + " with value: " + e.getValue() + ". This exception is ignored as failIfNotSet=false.", (Throwable)e);
        }
        return rc;
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurations) {
        this.configurationClasses = configurations;
    }

    public void addConfigurationClass(Class ... configuration) {
        String existing = this.configurationClasses;
        if (existing == null) {
            existing = "";
        }
        if (configuration != null) {
            for (Class clazz : configuration) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setConfigurationClasses(existing);
    }

    public void addConfiguration(Object configuration) {
        this.configurations.add(configuration);
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public String getRouteBuilderClasses() {
        return this.routeBuilderClasses;
    }

    public void setRouteBuilderClasses(String builders) {
        this.routeBuilderClasses = builders;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    public String getDefaultPropertyPlaceholderLocation() {
        return this.defaultPropertyPlaceholderLocation;
    }

    public void setDefaultPropertyPlaceholderLocation(String defaultPropertyPlaceholderLocation) {
        this.defaultPropertyPlaceholderLocation = defaultPropertyPlaceholderLocation;
    }

    @Deprecated
    public boolean isAutoConfigurationEnabled() {
        return this.mainConfigurationProperties.isAutoConfigurationEnabled();
    }

    @Deprecated
    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.mainConfigurationProperties.setAutoConfigurationEnabled(autoConfigurationEnabled);
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public void addProperty(String key, String value) {
        this.addInitialProperty(key, value);
    }

    public void addInitialProperty(String key, String value) {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        this.initialProperties.setProperty(key, value);
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public void addOverrideProperty(String key, String value) {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        this.overrideProperties.setProperty(key, value);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Deprecated
    public List<RoutesBuilder> getRouteBuilders() {
        return this.getRoutesBuilders();
    }

    @Deprecated
    public void setRouteBuilders(List<RoutesBuilder> routeBuilders) {
        this.setRoutesBuilders(routeBuilders);
    }

    public List<RoutesBuilder> getRoutesBuilders() {
        return this.routeBuilders;
    }

    public void setRoutesBuilders(List<RoutesBuilder> routesBuilders) {
        this.routeBuilders = routesBuilders;
    }

    public List<Object> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Object> configurations) {
        this.configurations = configurations;
    }

    public List<RouteDefinition> getRouteDefinitions() {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        if (this.camelContext != null) {
            answer.addAll(((Model)this.camelContext.getExtension(Model.class)).getRouteDefinitions());
        }
        return answer;
    }

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract CamelContext createCamelContext();

    protected void initCamelContext() throws Exception {
        this.camelContext = this.createCamelContext();
        if (this.camelContext == null) {
            throw new IllegalStateException("Created CamelContext is null");
        }
        this.postProcessCamelContext(this.camelContext);
    }

    protected void loadRouteBuilders(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (RoutesBuilder routesBuilder : this.getRoutesBuilders()) {
            postProcessor.postProcessBeforeInitialization((Object)routesBuilder, routesBuilder.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)routesBuilder, routesBuilder.getClass().getName());
        }
        if (this.routeBuilderClasses != null) {
            String[] routeClasses;
            for (String routeClass : routeClasses = this.routeBuilderClasses.split(",")) {
                Class routeClazz = camelContext.getClassResolver().resolveClass(routeClass);
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RouteBuilder) {
                    this.getRoutesBuilders().add((RoutesBuilder)((RouteBuilder)builder));
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
            }
        }
        if (this.mainConfigurationProperties.getPackageScanRouteBuilders() != null) {
            String[] pkgs = this.mainConfigurationProperties.getPackageScanRouteBuilders().split(",");
            Set set = ((ExtendedCamelContext)camelContext.getExtension(ExtendedCamelContext.class)).getPackageScanClassResolver().findImplementations(RoutesBuilder.class, pkgs);
            for (Class routeClazz : set) {
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RouteBuilder) {
                    this.getRoutesBuilders().add((RoutesBuilder)((RouteBuilder)builder));
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
            }
        }
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanPostProcessor();
        for (Object object : this.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        if (this.configurationClasses != null) {
            String[] configClasses;
            for (String configClass : configClasses = this.configurationClasses.split(",")) {
                Class configClazz = camelContext.getClassResolver().resolveClass(configClass);
                Object config = camelContext.getInjector().newInstance(configClazz);
                this.getConfigurations().add(config);
            }
        }
        for (Object object : this.getConfigurations()) {
            Method method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[0]);
            if (method == null) continue;
            LOG.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
            ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[0]);
        }
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        PropertiesComponent pc;
        if (this.propertyPlaceholderLocations != null) {
            pc = camelContext.getPropertiesComponent();
            pc.addLocation(this.propertyPlaceholderLocations);
            LOG.info("Using properties from: {}", (Object)this.propertyPlaceholderLocations);
        } else if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)this.defaultPropertyPlaceholderLocation) && !org.apache.camel.util.ObjectHelper.equal((Object)"false", (Object)this.defaultPropertyPlaceholderLocation)) {
            pc = camelContext.getPropertiesComponent();
            if (pc.getLocations().isEmpty()) {
                pc.addLocation(this.defaultPropertyPlaceholderLocation);
            }
            LOG.info("Using properties from {}", (Object)this.defaultPropertyPlaceholderLocation);
        }
        pc = camelContext.getPropertiesComponent();
        if (this.initialProperties != null) {
            pc.setInitialProperties(this.initialProperties);
        }
        if (this.overrideProperties != null) {
            pc.setOverrideProperties(this.overrideProperties);
        }
    }

    protected void configureLifecycle(CamelContext camelContext) throws Exception {
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        LinkedHashMap<String, String> autoConfiguredProperties = new LinkedHashMap<String, String>();
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFailFast(camelContext, autoConfiguredProperties);
            this.autoConfigurationPropertiesComponent(camelContext, autoConfiguredProperties);
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        }
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        this.loadConfigurations(camelContext);
        if (this.mainConfigurationProperties.isAutowireComponentProperties() || this.mainConfigurationProperties.isAutowireComponentPropertiesDeep()) {
            this.autowireConfigurationFromRegistry(camelContext, this.mainConfigurationProperties.isAutowireComponentPropertiesNonNullOnly(), this.mainConfigurationProperties.isAutowireComponentPropertiesDeep());
        }
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFromProperties(camelContext, autoConfiguredProperties);
        }
        if (this.mainConfigurationProperties.isAutowireComponentProperties() || this.mainConfigurationProperties.isAutowireComponentPropertiesDeep()) {
            this.autowireWildcardProperties(camelContext);
        }
        if (camelContext.isTracing().booleanValue() && !this.mainConfigurationProperties.isTracing()) {
            camelContext.setTracing(Boolean.FALSE);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            LOG.info("Auto-configuration summary:");
            autoConfiguredProperties.forEach((k, v) -> {
                boolean sensitive = SENSITIVE_KEYS.contains(k.toLowerCase(Locale.ENGLISH));
                if (sensitive) {
                    LOG.info("\t{}=xxxxxx", k);
                } else {
                    LOG.info("\t{}={}", k, v);
                }
            });
        }
    }

    protected void configureRoutes(CamelContext camelContext) throws Exception {
        this.loadRouteBuilders(camelContext);
        RoutesConfigurer configurer = new RoutesConfigurer(this.routesCollector, this.routeBuilders);
        configurer.configureRoutes(camelContext, this.mainConfigurationProperties);
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        camelContext.build();
        this.configurePropertiesService(camelContext);
        for (MainListener listener : this.listeners) {
            listener.beforeConfigure(this);
        }
        this.autoconfigure(camelContext);
        this.configureLifecycle(camelContext);
        this.configureRoutes(camelContext);
        for (MainListener listener : this.listeners) {
            listener.configure(camelContext);
        }
    }

    protected void autoConfigurationFailFast(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Object failFast;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        LOG.debug("Properties from Camel properties component:");
        for (String key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", (Object)key, (Object)prop.getProperty(key));
        }
        Object envEnabled = prop.remove("camel.main.autoConfigurationEnvironmentVariablesEnabled");
        if (envEnabled == null && (envEnabled = prop.remove("camel.main.auto-configuration-environment-variables-enabled")) != null) {
            PropertyBindingSupport.build().withMandatory(true).withIgnoreCase(true).bind(camelContext, (Object)this.mainConfigurationProperties, "autoConfigurationEnvironmentVariablesEnabled", envEnabled);
            autoConfiguredProperties.put("camel.main.auto-configuration-environment-variables-enabled", envEnabled.toString());
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = BaseMainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        Object object = failFast = propENV != null ? propENV.remove("camel.main.autoconfigurationfailfast") : null;
        if (failFast != null) {
            PropertyBindingSupport.build().withMandatory(true).withIgnoreCase(true).bind(camelContext, (Object)this.mainConfigurationProperties, "autoConfigurationFailFast", failFast);
        } else {
            failFast = prop.remove("camel.main.autoConfigurationFailFast");
            if (failFast == null) {
                failFast = prop.remove("camel.main.auto-configuration-fail-fast");
            }
            if (failFast != null) {
                PropertyBindingSupport.build().withMandatory(true).withIgnoreCase(true).bind(camelContext, (Object)this.mainConfigurationProperties, "autoConfigurationFailFast", failFast);
                autoConfiguredProperties.put("camel.main.auto-configuration-fail-fast", failFast.toString());
            }
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        RestConfiguration rest;
        Resilience4jConfigurationDefinition resilience4j;
        HystrixConfigurationDefinition hystrix;
        ModelCamelContext model;
        Properties propENV;
        if (config.getFileConfigurations() != null) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                Object pattern;
                File[] files;
                String path = FileUtil.onlyPath((String)loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> BaseMainSupport.lambda$doConfigureCamelContextFromMainConfiguration$3((String)(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null), arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
        DefaultConfigurationConfigurer.configure(camelContext, config);
        DefaultConfigurationConfigurer.afterPropertiesSet(camelContext);
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = BaseMainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        LinkedHashMap<String, Object> contextProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> hystrixProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> resilience4jProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> restProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> beansProperties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            String option;
            String value;
            if (key.startsWith("camel.context.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                contextProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.hystrix.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                hystrixProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.resilience4j.")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                resilience4jProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (key.startsWith("camel.rest.")) {
                value = prop.getProperty(key);
                option = key.substring(11);
                BaseMainSupport.validateOptionAndValue(key, option, value);
                restProperties.put(BaseMainSupport.optionKey(option), value);
                continue;
            }
            if (!key.startsWith("camel.beans.")) continue;
            value = prop.getProperty(key);
            option = key.substring(12);
            BaseMainSupport.validateOptionAndValue(key, option, value);
            beansProperties.put(BaseMainSupport.optionKey(option), value);
        }
        if (!beansProperties.isEmpty()) {
            LOG.debug("Creating and binding beans to registry from loaded properties: {}", (Object)beansProperties.size());
            this.bindBeansToRegistry(camelContext, beansProperties, "camel.beans.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!contextProperties.isEmpty()) {
            LOG.debug("Auto-configuring CamelContext from loaded properties: {}", (Object)contextProperties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, camelContext, contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!hystrixProperties.isEmpty()) {
            LOG.debug("Auto-configuring Hystrix Circuit Breaker EIP from loaded properties: {}", (Object)hystrixProperties.size());
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            hystrix = model.getHystrixConfiguration(null);
            if (hystrix == null) {
                hystrix = new HystrixConfigurationDefinition();
                model.setHystrixConfiguration(hystrix);
            }
            BaseMainSupport.setPropertiesOnTarget(camelContext, hystrix, hystrixProperties, "camel.hystrix.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!resilience4jProperties.isEmpty()) {
            LOG.debug("Auto-configuring Resilience4j Circuit Breaker EIP from loaded properties: {}", (Object)resilience4jProperties.size());
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            resilience4j = model.getResilience4jConfiguration(null);
            if (resilience4j == null) {
                resilience4j = new Resilience4jConfigurationDefinition();
                model.setResilience4jConfiguration(resilience4j);
            }
            BaseMainSupport.setPropertiesOnTarget(camelContext, resilience4j, resilience4jProperties, "camel.resilience4j.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!restProperties.isEmpty()) {
            LOG.debug("Auto-configuring Rest DSL from loaded properties: {}", (Object)restProperties.size());
            rest = camelContext.getRestConfiguration();
            if (rest == null) {
                rest = new RestConfiguration();
                camelContext.setRestConfiguration(rest);
            }
            BaseMainSupport.setPropertiesOnTarget(camelContext, rest, restProperties, "camel.rest.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!beansProperties.isEmpty()) {
            beansProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.beans.{}={}", k, v));
        }
        if (!contextProperties.isEmpty()) {
            contextProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.context.{}={} on bean: {}", new Object[]{k, v, camelContext}));
        }
        if (!hystrixProperties.isEmpty()) {
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            hystrix = model.getHystrixConfiguration(null);
            hystrixProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.hystrix.{}={} on bean: {}", new Object[]{k, v, hystrix}));
        }
        if (!resilience4jProperties.isEmpty()) {
            model = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
            resilience4j = model.getResilience4jConfiguration(null);
            resilience4jProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.resilience4j.{}={} on bean: {}", new Object[]{k, v, resilience4j}));
        }
        if (!restProperties.isEmpty()) {
            rest = camelContext.getRestConfiguration();
            restProperties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.rest.{}={} on bean: {}", new Object[]{k, v, rest}));
        }
    }

    private void bindBeansToRegistry(CamelContext camelContext, Map<String, Object> properties, String optionPrefix, boolean failIfNotSet, boolean ignoreCase, Map<String, String> autoConfiguredProperties) throws Exception {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(properties.keySet());
        for (String key : keys) {
            if (key.indexOf(46) != -1) continue;
            String name = key;
            Object value = properties.remove(key);
            Object bean = PropertyBindingSupport.resolveBean((CamelContext)camelContext, (String)name, (Object)value);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot create/resolve bean with name " + name + " from value: " + value);
            }
            camelContext.getRegistry().bind(name, bean);
            autoConfiguredProperties.put(optionPrefix + key, value.toString());
            Map config = PropertiesHelper.extractProperties(properties, (String)(key + "."));
            BaseMainSupport.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + key + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
            LOG.info("Binding bean: {} (type: {}) to the registry", (Object)key, (Object)org.apache.camel.util.ObjectHelper.classCanonicalName((Object)bean));
        }
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = BaseMainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.component.properties.")) continue;
            int dot = key.indexOf(".", 26);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            BaseMainSupport.validateOptionAndValue(key, option, value);
            properties.put(BaseMainSupport.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring properties component from loaded properties: {}", (Object)properties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, camelContext.getPropertiesComponent(), properties, "camel.component.properties.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.component.properties.{}={} on object: {}", new Object[]{k, v, camelContext.getPropertiesComponent()}));
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = BaseMainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            BaseMainSupport.validateOptionAndValue(key, option, value);
            properties.put(BaseMainSupport.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring main from loaded properties: {}", (Object)properties.size());
            BaseMainSupport.setPropertiesOnTarget(camelContext, config, properties, "camel.main.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((k, v) -> LOG.warn("Property not auto-configured: camel.main.{}={} on bean: {}", new Object[]{k, v, config}));
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext, Map<String, String> autoConfiguredProperties) throws Exception {
        Properties propENV;
        OrderedProperties prop = new OrderedProperties();
        try {
            InputStream is = camelContext.getClassResolver().loadResourceAsStream("/META-INF/services/org/apache/camel/autowire.properties");
            if (is != null) {
                prop.load(is);
                if (!prop.isEmpty()) {
                    LOG.info("Autowired enabled from classpath: META-INF/services/org/apache/camel/autowire.properties with {} properties", (Object)prop.size());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Properties from classpath: META-INF/services/org/apache/camel/autowire.properties:");
                        for (String string : prop.stringPropertyNames()) {
                            LOG.debug("    {}={}", (Object)string, (Object)prop.getProperty(string));
                        }
                    }
                }
                IOHelper.close((Closeable)is);
            }
        }
        catch (Throwable is) {
            // empty catch block
        }
        Properties propPC = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        prop.putAll((Map<?, ?>)propPC);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = BaseMainSupport.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.", "camel.dataformat.", "camel.language."})).isEmpty()) {
            prop.putAll((Map<?, ?>)propENV);
        }
        LinkedHashMap<PropertyOptionKey, Map<String, Object>> properties = new LinkedHashMap<PropertyOptionKey, Map<String, Object>>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            this.wildcardProperties.put(key, prop.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            prop.remove(key);
        }
        for (String key : prop.stringPropertyNames()) {
            BaseMainSupport.computeProperties("camel.component.", key, (Properties)prop, properties, name -> {
                Component target = camelContext.getComponent(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find component with name " + name + ". Make sure you have the component on the classpath");
                }
                return Collections.singleton(target);
            });
            BaseMainSupport.computeProperties("camel.dataformat.", key, (Properties)prop, properties, name -> {
                DataFormat target = camelContext.resolveDataFormat(name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find dataformat with name " + name + ". Make sure you have the dataformat on the classpath");
                }
                return Collections.singleton(target);
            });
            BaseMainSupport.computeProperties("camel.language.", key, (Properties)prop, properties, name -> {
                Language target;
                try {
                    target = camelContext.resolveLanguage(name);
                }
                catch (NoSuchLanguageException e) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find language with name " + name + ". Make sure you have the language on the classpath");
                }
                return Collections.singleton(target);
            });
        }
        if (!properties.isEmpty()) {
            long l = properties.values().stream().mapToLong(Map::size).sum();
            LOG.debug("Auto-configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)l);
        }
        for (Map.Entry entry : properties.entrySet()) {
            BaseMainSupport.setPropertiesOnTarget(camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (Map)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            for (PropertyOptionKey pok : properties.keySet()) {
                Map values = (Map)properties.get(pok);
                values.forEach((k, v) -> {
                    String stringValue = v != null ? v.toString() : null;
                    LOG.warn("Property ({}={}) not auto-configured with name: {} on bean: {} with value: {}", new Object[]{pok.getOptionPrefix() + "." + k, stringValue, k, pok.getInstance(), stringValue});
                });
            }
        }
    }

    protected void autowireConfigurationFromRegistry(final CamelContext camelContext, final boolean bindNullOnly, final boolean deepNesting) throws Exception {
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                PropertyBindingSupport.autowireSingletonPropertiesFromRegistry((CamelContext)camelContext, (Object)component, (boolean)bindNullOnly, (boolean)deepNesting, (obj, propertyName, type, value) -> LOG.info("Autowired property: {} on component: {} as exactly one instance of type: {} found in the registry", new Object[]{propertyName, component.getClass().getSimpleName(), type.getName()}));
            }
        });
    }

    protected void autowireWildcardProperties(CamelContext camelContext) {
        if (this.wildcardProperties.isEmpty()) {
            return;
        }
        for (String name : camelContext.getComponentNames()) {
            Component comp = camelContext.getComponent(name);
            this.doAutowireWildcardProperties(name, comp);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                BaseMainSupport.this.doAutowireWildcardProperties(name, component);
            }
        });
    }

    protected void doAutowireWildcardProperties(String name, Component component) {
        LinkedHashMap<PropertyOptionKey, Map<String, Object>> properties = new LinkedHashMap<PropertyOptionKey, Map<String, Object>>();
        LinkedHashMap<String, String> autoConfiguredProperties = new LinkedHashMap<String, String>();
        String match = ("camel.component." + name).toLowerCase(Locale.ENGLISH);
        for (String string : this.wildcardProperties.stringPropertyNames()) {
            String mKey = string.substring(0, string.indexOf(42)).toLowerCase(Locale.ENGLISH);
            if (!match.startsWith(mKey)) continue;
            BaseMainSupport.computeProperties("camel.component.", string, this.wildcardProperties, properties, s -> Collections.singleton(component));
        }
        try {
            for (Map.Entry entry : properties.entrySet()) {
                BaseMainSupport.setPropertiesOnTarget(this.camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (Map)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            }
            if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
                LOG.info("Auto-configuration component {} summary:", (Object)name);
                autoConfiguredProperties.forEach((k, v) -> {
                    boolean sensitive = SENSITIVE_KEYS.contains(k.toLowerCase(Locale.ENGLISH));
                    if (sensitive) {
                        LOG.info("\t{}=xxxxxx", k);
                    } else {
                        LOG.info("\t{}={}", k, v);
                    }
                });
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
        }
    }

    protected static void validateOptionAndValue(String key, String option, String value) {
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)option)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because option is empty");
        }
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)value)) {
            throw new IllegalArgumentException("Error configuring property: " + key + " because value is empty");
        }
    }

    @Deprecated
    public void addRouteBuilder(RoutesBuilder routeBuilder) {
        this.getRoutesBuilders().add(routeBuilder);
    }

    public void addRoutesBuilder(RoutesBuilder routeBuilder) {
        this.getRoutesBuilders().add(routeBuilder);
    }

    public void addRouteBuilder(Class ... routeBuilder) {
        String existing = this.routeBuilderClasses;
        if (existing == null) {
            existing = "";
        }
        if (routeBuilder != null) {
            for (Class clazz : routeBuilder) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setRouteBuilderClasses(existing);
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    protected static void computeProperties(String keyPrefix, String key, Properties prop, Map<PropertyOptionKey, Map<String, Object>> properties, Function<String, Iterable<Object>> supplier) {
        if (key.startsWith(keyPrefix)) {
            String name;
            int dot = key.indexOf(".", keyPrefix.length());
            String string = name = dot == -1 ? key.substring(keyPrefix.length()) : key.substring(keyPrefix.length(), dot);
            if ("enabled".equals(name)) {
                return;
            }
            if ("properties".equals(name)) {
                return;
            }
            if (!BaseMainSupport.isServiceEnabled(keyPrefix, name, prop)) {
                return;
            }
            String prefix = dot == -1 ? "" : key.substring(0, dot + 1);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            if ("enabled".equalsIgnoreCase(option)) {
                return;
            }
            BaseMainSupport.validateOptionAndValue(key, option, value);
            Iterable<Object> targets = supplier.apply(name);
            for (Object target : targets) {
                PropertyOptionKey pok = new PropertyOptionKey(target, prefix);
                Map values = properties.computeIfAbsent(pok, k -> new LinkedHashMap());
                values.put(BaseMainSupport.optionKey(option), value);
            }
        }
    }

    protected static boolean isServiceEnabled(String prefix, String name, Properties properties) {
        org.apache.camel.util.ObjectHelper.notNull((Object)prefix, (String)"prefix");
        org.apache.camel.util.ObjectHelper.notNull((Object)name, (String)"name");
        org.apache.camel.util.ObjectHelper.notNull((Object)properties, (String)"properties");
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String group = properties.getProperty(prefix + "enabled", "true");
        String item = properties.getProperty(prefix + name + ".enabled", group);
        return Boolean.parseBoolean(item);
    }

    private static /* synthetic */ boolean lambda$doConfigureCamelContextFromMainConfiguration$3(String pattern, File f) {
        return StringHelper.matches((String)pattern, (String)f.getName());
    }

    private static /* synthetic */ void lambda$loadEnvironmentVariablesAsProperties$0(String pk, String pk2, Properties answer, String k, String v) {
        if ((k = k.toUpperCase(Locale.US)).startsWith(pk) || k.startsWith(pk2)) {
            String key = k.toLowerCase(Locale.ENGLISH).replace('_', '.');
            answer.put(key, v);
        }
    }

    private static final class PropertyOptionKey {
        private final Object instance;
        private final String optionPrefix;

        private PropertyOptionKey(Object instance, String optionPrefix) {
            this.instance = org.apache.camel.util.ObjectHelper.notNull((Object)instance, (String)"instance");
            this.optionPrefix = (String)org.apache.camel.util.ObjectHelper.notNull((Object)optionPrefix, (String)"optionPrefix");
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getOptionPrefix() {
            return this.optionPrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyOptionKey)) {
                return false;
            }
            PropertyOptionKey key = (PropertyOptionKey)o;
            return Objects.equals(this.instance, key.instance) && Objects.equals(this.optionPrefix, key.optionPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.instance, this.optionPrefix);
        }
    }
}

