/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.camel.util.StringHelper;

public final class ThreadHelper {
    public static final String DEFAULT_PATTERN = "Camel Thread ##counter# - #name#";
    private static final Pattern INVALID_PATTERN = Pattern.compile(".*#\\w+#.*");
    private static AtomicLong threadCounter = new AtomicLong();

    private ThreadHelper() {
    }

    private static long nextThreadCounter() {
        return threadCounter.getAndIncrement();
    }

    public static String resolveThreadName(String pattern, String name) {
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        String longName = name;
        String shortName = name.contains("?") ? StringHelper.before(name, "?") : name;
        String answer = StringHelper.replaceAll(pattern, "#counter#", "" + ThreadHelper.nextThreadCounter());
        answer = StringHelper.replaceAll(answer, "#longName#", longName);
        if (INVALID_PATTERN.matcher(answer = StringHelper.replaceAll(answer, "#name#", shortName)).matches()) {
            throw new IllegalArgumentException("Pattern is invalid: " + pattern);
        }
        return answer;
    }
}

