/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.service;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceSupport
implements StatefulService {
    protected static final byte NEW = 0;
    protected static final byte BUILDED = 1;
    protected static final byte INITIALIZED = 2;
    protected static final byte STARTING = 3;
    protected static final byte STARTED = 4;
    protected static final byte SUSPENDING = 5;
    protected static final byte SUSPENDED = 6;
    protected static final byte STOPPING = 7;
    protected static final byte STOPPED = 8;
    protected static final byte SHUTTINGDOWN = 9;
    protected static final byte SHUTDOWN = 10;
    protected static final byte FAILED = 11;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceSupport.class);
    protected final Object lock = new Object();
    protected volatile byte status = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build() {
        if (this.status == 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status == 0) {
                    LOG.trace("Building service: {}", (Object)this);
                    try {
                        this.doBuild();
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException(e);
                    }
                    this.status = 1;
                    LOG.trace("Built service: {}", (Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.status <= 1 || this.status >= 8) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status <= 1 || this.status >= 8) {
                    LOG.trace("Initializing service: {}", (Object)this);
                    try {
                        this.doInit();
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeException(e);
                    }
                    this.status = (byte)2;
                    LOG.trace("Initialized service: {}", (Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 4) {
                LOG.trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 3) {
                LOG.trace("Service: {} already starting", (Object)this);
                return;
            }
            try {
                this.init();
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error while initializing service: " + this, (Throwable)e);
                throw e;
            }
            try {
                this.status = (byte)3;
                LOG.trace("Starting service: {}", (Object)this);
                this.doStart();
                this.status = (byte)4;
                LOG.trace("Started service: {}", (Object)this);
            }
            catch (Exception e) {
                try {
                    this.stop();
                }
                catch (Exception e2) {
                    LOG.trace("Error while stopping service after it failed to start: " + this + ". This exception is ignored", (Throwable)e);
                }
                this.status = (byte)11;
                LOG.trace("Error while starting service: " + this, (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 11) {
                LOG.trace("Service: {} failed and regarded as already stopped", (Object)this);
                return;
            }
            if (this.status == 8 || this.status == 9 || this.status == 10) {
                LOG.trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 7) {
                LOG.trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = (byte)7;
            LOG.trace("Stopping service: {}", (Object)this);
            try {
                this.doStop();
                this.status = (byte)8;
                LOG.trace("Stopped: {} service", (Object)this);
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error while stopping service: " + this, (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 6) {
                LOG.trace("Service: {} already suspended", (Object)this);
                return;
            }
            if (this.status == 5) {
                LOG.trace("Service: {} already suspending", (Object)this);
                return;
            }
            this.status = (byte)5;
            LOG.trace("Suspending service: {}", (Object)this);
            try {
                this.doSuspend();
                this.status = (byte)6;
                LOG.trace("Suspended service: {}", (Object)this);
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error while suspending service: " + this, (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status != 6) {
                LOG.trace("Service is not suspended: {}", (Object)this);
                return;
            }
            this.status = (byte)3;
            LOG.trace("Resuming service: {}", (Object)this);
            try {
                this.doResume();
                this.status = (byte)4;
                LOG.trace("Resumed service: {}", (Object)this);
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error while resuming service: " + this, (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 10) {
                LOG.trace("Service: {} already shutdown", (Object)this);
                return;
            }
            if (this.status == 9) {
                LOG.trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = (byte)10;
            LOG.trace("Shutting down service: {}", (Object)this);
            try {
                this.doShutdown();
                LOG.trace("Shutdown service: {}", (Object)this);
                this.status = (byte)10;
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error shutting down service: " + this, (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
    }

    @Override
    public ServiceStatus getStatus() {
        switch (this.status) {
            case 3: {
                return ServiceStatus.Starting;
            }
            case 4: {
                return ServiceStatus.Started;
            }
            case 5: {
                return ServiceStatus.Suspending;
            }
            case 6: {
                return ServiceStatus.Suspended;
            }
            case 7: {
                return ServiceStatus.Stopping;
            }
        }
        return ServiceStatus.Stopped;
    }

    public boolean isNew() {
        return this.status == 0;
    }

    public boolean isBuild() {
        return this.status == 1;
    }

    public boolean isInit() {
        return this.status == 2;
    }

    @Override
    public boolean isStarted() {
        return this.status == 4;
    }

    @Override
    public boolean isStarting() {
        return this.status == 3;
    }

    @Override
    public boolean isStopping() {
        return this.status == 7;
    }

    @Override
    public boolean isStopped() {
        return this.status < 3 || this.status >= 8;
    }

    @Override
    public boolean isSuspending() {
        return this.status == 5;
    }

    @Override
    public boolean isSuspended() {
        return this.status == 6;
    }

    @Override
    public boolean isRunAllowed() {
        return this.status >= 3 && this.status <= 6;
    }

    public boolean isShutdown() {
        return this.status == 10;
    }

    public boolean isStoppingOrStopped() {
        return this.status < 3 || this.status > 6;
    }

    public boolean isSuspendingOrSuspended() {
        return this.status == 5 || this.status == 6;
    }

    public boolean isStartingOrStarted() {
        return this.status == 3 || this.status == 4;
    }

    protected void doBuild() throws Exception {
    }

    protected void doInit() throws Exception {
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    protected void doSuspend() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected void doShutdown() throws Exception {
    }
}

