/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ByteBasedScanner;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public abstract class StreamScanner
extends ByteBasedScanner {
    protected InputStream _in;
    protected byte[] _inputBuffer;

    public StreamScanner(ReaderConfig cfg, InputStream in, byte[] buffer, int ptr, int last) {
        super(cfg);
        this._in = in;
        this._inputBuffer = buffer;
        this._inputPtr = ptr;
        this._inputEnd = last;
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullBBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected abstract int handleEntityInText(boolean var1) throws XMLStreamException;

    protected abstract String parsePublicId(byte var1) throws XMLStreamException;

    protected abstract String parseSystemId(byte var1) throws XMLStreamException;

    @Override
    public final int nextFromProlog(boolean isProlog) throws XMLStreamException {
        byte b;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        this.setStartLocation();
        while (true) {
            int c;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.setStartLocation();
                return -1;
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) == 60) break;
            if (c == 32) continue;
            if (c == 10) {
                this.markLF();
                continue;
            }
            if (c == 13) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    this.setStartLocation();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (c == 9) continue;
            this.reportPrologUnexpChar(isProlog, this.decodeCharForError((byte)c), null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 33) {
            return this.handlePrologDeclStart(isProlog);
        }
        if (b == 63) {
            return this.handlePIStart();
        }
        if (b == 47 || !isProlog) {
            this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (unbalanced start/end tags?)");
        }
        return this.handleStartElement(b);
    }

    @Override
    public final int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                return this._nextEntity();
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            return this._nextEntity();
        }
        this.setStartLocation();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.setStartLocation();
            return -1;
        }
        byte b = this._inputBuffer[this._inputPtr];
        if (b == 60) {
            ++this._inputPtr;
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (b == 33) {
                return this.handleCommentOrCdataStart();
            }
            if (b == 63) {
                return this.handlePIStart();
            }
            if (b == 47) {
                return this.handleEndElement();
            }
            return this.handleStartElement(b);
        }
        if (b == 38) {
            ++this._inputPtr;
            int i = this.handleEntityInText(false);
            if (i == 0) {
                this._currToken = 9;
                return 9;
            }
            this._tmpChar = -i;
        } else {
            this._tmpChar = b & 0xFF;
        }
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._currToken = 4;
        return 4;
    }

    protected int _nextEntity() {
        this._textBuilder.resetWithEmpty();
        this._currToken = 9;
        return 9;
    }

    private final int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
                if (this._cfgLazyParsing) {
                    this._tokenIncomplete = true;
                } else {
                    this.finishComment();
                }
                this._currToken = 5;
                return 5;
            }
        } else if (b == 68 && isProlog) {
            this.handleDtdStart();
            if (!this._cfgLazyParsing && this._tokenIncomplete) {
                this.finishDTD(true);
                this._tokenIncomplete = false;
            }
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private final int handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        byte b = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(b);
        b = this.skipInternalWs(false, null);
        if (b == 80) {
            this.matchAsciiKeyword("PUBLIC");
            b = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(b);
            b = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(b);
            b = this.skipInternalWs(false, null);
        } else if (b == 83) {
            this.matchAsciiKeyword("SYSTEM");
            b = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(b);
            b = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (b == 62) {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return 11;
        }
        if (b != 91) {
            String msg = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(this.decodeCharForError(b), msg);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
        return 11;
    }

    private final int handleCommentOrCdataStart() throws XMLStreamException {
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) != 45) {
                this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected '-' for COMMENT)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishComment();
            }
            this._currToken = 5;
            return 5;
        }
        if (b == 91) {
            this._currToken = 12;
            for (int i = 0; i < 6; ++i) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                int ch = this.decodeCharForError(b);
                this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishCData();
            }
            return 12;
        }
        this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    private final int handlePIStart() throws XMLStreamException {
        int c;
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte b = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(b);
        String ln = this._tokenName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) {
            while (true) {
                if (c == 10) {
                    this.markLF();
                } else if (c == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (c != 32 && c != 9) {
                    this.throwInvalidSpace(c);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr] & 0xFF) > 32) break;
                ++this._inputPtr;
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishPI();
            }
        } else {
            if (c != 63) {
                this.reportMissingPISpace(this.decodeCharForError((byte)c));
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) != 62) {
                this.reportMissingPISpace(this.decodeCharForError(b));
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    protected final int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte b = this._inputBuffer[this._inputPtr++];
        int value = 0;
        if (b == 120) {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b = this._inputBuffer[this._inputPtr++]) != 59) {
                    value <<= 4;
                    byte c = b;
                    if (c <= 57 && c >= 48) {
                        value += c - 48;
                    } else if (c >= 97 && c <= 102) {
                        value += 10 + (c - 97);
                    } else if (c >= 65 && c <= 70) {
                        value += 10 + (c - 65);
                    } else {
                        this.throwUnexpectedChar(this.decodeCharForError(b), "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (value <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (b != 59) {
                byte c = b;
                if (c <= 57 && c >= 48) {
                    if ((value = value * 10 + (c - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(this.decodeCharForError(b), "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                b = this._inputBuffer[this._inputPtr++];
            }
        }
        this.verifyXmlChar(value);
        return value;
    }

    protected abstract int handleStartElement(byte var1) throws XMLStreamException;

    protected final int handleEndElement() throws XMLStreamException {
        int q;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        int size = this._tokenName.sizeInQuads();
        if (this._inputEnd - this._inputPtr < (size << 2) + 1) {
            return this.handleEndElementSlow(size);
        }
        int ptr = this._inputPtr;
        byte[] buf = this._inputBuffer;
        --size;
        for (int qix = 0; qix < size; ++qix) {
            q = buf[ptr] << 24 | (buf[ptr + 1] & 0xFF) << 16 | (buf[ptr + 2] & 0xFF) << 8 | buf[ptr + 3] & 0xFF;
            ptr += 4;
            if (q == this._tokenName.getQuad(qix)) continue;
            this._inputPtr = ptr;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int lastQ = this._tokenName.getQuad(size);
        if ((q = buf[ptr++] & 0xFF) != lastQ && (q = q << 8 | buf[ptr++] & 0xFF) != lastQ && (q = q << 8 | buf[ptr++] & 0xFF) != lastQ && (q = q << 8 | buf[ptr++] & 0xFF) != lastQ) {
            this._inputPtr = ptr;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int i2 = this._inputBuffer[ptr] & 0xFF;
        this._inputPtr = ptr + 1;
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                byte b;
                byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b != 10) {
                    this.markLF(this._inputPtr - 1);
                    i2 = b & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        return 2;
    }

    private final int handleEndElementSlow(int size) throws XMLStreamException {
        block14: {
            int i;
            int q;
            --size;
            for (int qix = 0; qix < size; ++qix) {
                q = 0;
                for (i = 0; i < 4; ++i) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    q = q << 8 | this._inputBuffer[this._inputPtr++] & 0xFF;
                }
                if (q == this._tokenName.getQuad(qix)) continue;
                this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
            }
            int lastQ = this._tokenName.getQuad(size);
            q = 0;
            i = 0;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((q = q << 8 | this._inputBuffer[this._inputPtr++] & 0xFF) == lastQ) break block14;
            } while (++i <= 3);
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int i2 = this._inputBuffer[this._inputPtr++];
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                byte b;
                byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b != 10) {
                    this.markLF(this._inputPtr - 1);
                    i2 = b & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        return 2;
    }

    protected final PName parsePName(byte b) throws XMLStreamException {
        int i2;
        if (this._inputEnd - this._inputPtr < 8) {
            return this.parsePNameSlow(b);
        }
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 1);
        }
        q = q << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 2);
        }
        q = q << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 3);
        }
        q = q << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 4);
        }
        return this.parsePNameMedium(i2, q);
    }

    protected PName parsePNameMedium(int i2, int q1) throws XMLStreamException {
        int q2 = i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 1);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 2);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 3);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 4);
        }
        int[] quads = this._quadBuffer;
        quads[0] = q1;
        quads[1] = q2;
        return this.parsePNameLong(i2, quads);
    }

    protected final PName parsePNameLong(int q, int[] quads) throws XMLStreamException {
        int qix = 2;
        while (true) {
            int i2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 1);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 2);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 3);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 4);
            }
            if (qix >= quads.length) {
                quads = DataUtil.growArrayBy(quads, quads.length);
                this._quadBuffer = quads;
            }
            quads[qix] = q;
            ++qix;
            q = i2;
        }
    }

    protected final PName parsePNameSlow(byte b) throws XMLStreamException {
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        int[] quads = this._quadBuffer;
        int qix = 0;
        int firstQuad = 0;
        while (true) {
            int i2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 1, firstQuad, qix, quads);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 2, firstQuad, qix, quads);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 3, firstQuad, qix, quads);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 4, firstQuad, qix, quads);
            }
            if (qix == 0) {
                firstQuad = q;
            } else if (qix == 1) {
                quads[0] = firstQuad;
                quads[1] = q;
            } else {
                if (qix >= quads.length) {
                    this._quadBuffer = quads = DataUtil.growArrayBy(quads, quads.length);
                }
                quads[qix] = q;
            }
            ++qix;
            q = i2;
        }
    }

    private final PName findPName(int onlyQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int hash = ByteBasedPNameTable.calcHash(onlyQuad);
        PName name = this._symbols.findSymbol(hash, onlyQuad, 0);
        if (name == null) {
            this._quadBuffer[0] = onlyQuad;
            name = this.addPName(hash, this._quadBuffer, 1, lastByteCount);
        }
        return name;
    }

    private final PName findPName(int firstQuad, int secondQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int hash = ByteBasedPNameTable.calcHash(firstQuad, secondQuad);
        PName name = this._symbols.findSymbol(hash, firstQuad, secondQuad);
        if (name == null) {
            this._quadBuffer[0] = firstQuad;
            this._quadBuffer[1] = secondQuad;
            name = this.addPName(hash, this._quadBuffer, 2, lastByteCount);
        }
        return name;
    }

    private final PName findPName(int lastQuad, int[] quads, int qlen, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        if (qlen >= quads.length) {
            quads = DataUtil.growArrayBy(quads, quads.length);
            this._quadBuffer = quads;
        }
        quads[qlen++] = lastQuad;
        int hash = ByteBasedPNameTable.calcHash(quads, qlen);
        PName name = this._symbols.findSymbol(hash, quads, qlen);
        if (name == null) {
            name = this.addPName(hash, quads, qlen, lastByteCount);
        }
        return name;
    }

    private final PName findPName(int lastQuad, int lastByteCount, int firstQuad, int qlen, int[] quads) throws XMLStreamException {
        if (qlen <= 1) {
            if (qlen == 0) {
                return this.findPName(lastQuad, lastByteCount);
            }
            return this.findPName(firstQuad, lastQuad, lastByteCount);
        }
        return this.findPName(lastQuad, quads, qlen, lastByteCount);
    }

    protected byte skipInternalWs(boolean reqd, String msg) throws XMLStreamException {
        byte b;
        int c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) {
            if (!reqd) {
                return b;
            }
            this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected white space " + msg + ")");
        }
        do {
            if (b == 10) {
                this.markLF();
            } else if (b == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (b != 32 && b != 9) {
                this.throwInvalidSpace(b);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while (((b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
        return b;
    }

    private final void matchAsciiKeyword(String keyw) throws XMLStreamException {
        int len = keyw.length();
        for (int i = 1; i < len; ++i) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == (byte)keyw.charAt(i)) continue;
            this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected '" + keyw.charAt(i) + "' for " + keyw + " keyword)");
        }
    }

    protected final int checkInTreeIndentation(int c) throws XMLStreamException {
        int count;
        int max;
        byte b;
        if (c == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr]) != 32 && b != 9) {
            if (b == 60 && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != 33) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n = max = b == 32 ? 32 : 8;
        for (count = 1; count <= max; ++count) {
            byte b2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr]) != b) {
                if (b2 != 60 || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == 33) break;
                this._textBuilder.resetWithIndentation(count, (char)b);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] outBuf = this._textBuilder.resetWithEmpty();
        outBuf[0] = 10;
        char ind = (char)b;
        for (int i = 1; i <= count; ++i) {
            outBuf[i] = ind;
        }
        this._textBuilder.setCurrentLength(++count);
        return count;
    }

    protected final int checkPrologIndentation(int c) throws XMLStreamException {
        int max;
        if (c == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        byte b = this._inputBuffer[this._inputPtr];
        if (b != 32 && b != 9) {
            if (b == 60) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int count = 1;
        int n = max = b == 32 ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == b) {
            ++this._inputPtr;
            if (++count < max) continue;
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            char ind = (char)b;
            for (int i = 1; i <= count; ++i) {
                outBuf[i] = ind;
            }
            this._textBuilder.setCurrentLength(++count);
            return count;
        }
        this._textBuilder.resetWithIndentation(count, (char)b);
        return -1;
    }

    @Override
    protected final boolean loadMore() throws XMLStreamException {
        this._pastBytesOrChars += (long)this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        try {
            int count = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count < 1) {
                this._inputEnd = 0;
                if (count == 0) {
                    this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = count;
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final byte nextByte(int tt) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(tt));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte nextByte() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne(int type) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(type));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadAndRetain(int nrOfChars) throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this._pastBytesOrChars += (long)this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int remaining = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, remaining);
        this._inputPtr = 0;
        this._inputEnd = remaining;
        try {
            do {
                int max;
                int count;
                if ((count = this._in.read(this._inputBuffer, this._inputEnd, max = this._inputBuffer.length - this._inputEnd)) < 1) {
                    if (count == 0) {
                        this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + max);
                    }
                    return false;
                }
                this._inputEnd += count;
            } while (this._inputEnd < nrOfChars);
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }
}

