/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.Optional;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SagaActionUriDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SagaOptionDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.processor.saga.SagaProcessorBuilder;
import org.apache.camel.processor.saga.SagaPropagation;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

public class SagaReifier
extends ProcessorReifier<SagaDefinition> {
    public SagaReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (SagaDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        SagaCompletionMode completionMode;
        Optional<Endpoint> compensationEndpoint = Optional.ofNullable(((SagaDefinition)this.definition).getCompensation()).map(SagaActionUriDefinition::getUri).map(arg_0 -> ((RouteContext)this.routeContext).resolveEndpoint(arg_0));
        Optional<Endpoint> completionEndpoint = Optional.ofNullable(((SagaDefinition)this.definition).getCompletion()).map(SagaActionUriDefinition::getUri).map(arg_0 -> ((RouteContext)this.routeContext).resolveEndpoint(arg_0));
        TreeMap<String, ExpressionDefinition> optionsMap = new TreeMap<String, ExpressionDefinition>();
        if (((SagaDefinition)this.definition).getOptions() != null) {
            for (SagaOptionDefinition optionDef : ((SagaDefinition)this.definition).getOptions()) {
                String optionName = optionDef.getOptionName();
                ExpressionDefinition expr = optionDef.getExpression();
                optionsMap.put(optionName, expr);
            }
        }
        CamelSagaStep step = new CamelSagaStep(compensationEndpoint, completionEndpoint, optionsMap, Optional.ofNullable(this.parseLong(((SagaDefinition)this.definition).getTimeoutInMilliseconds())));
        SagaPropagation propagation = this.parse(SagaPropagation.class, ((SagaDefinition)this.definition).getPropagation());
        if (propagation == null) {
            propagation = SagaPropagation.REQUIRED;
        }
        if ((completionMode = this.parse(SagaCompletionMode.class, ((SagaDefinition)this.definition).getCompletionMode())) == null) {
            completionMode = SagaCompletionMode.defaultCompletionMode();
        }
        Processor childProcessor = this.createChildProcessor(true);
        CamelSagaService camelSagaService = this.findSagaService(this.camelContext);
        camelSagaService.registerStep(step);
        return new SagaProcessorBuilder().camelContext(this.camelContext).childProcessor(childProcessor).sagaService(camelSagaService).step(step).propagation(propagation).completionMode(completionMode).build();
    }

    protected CamelSagaService findSagaService(CamelContext context) {
        CamelSagaService sagaService = ((SagaDefinition)this.definition).getSagaService();
        if (sagaService != null) {
            return sagaService;
        }
        if (((SagaDefinition)this.definition).getSagaServiceRef() != null) {
            return (CamelSagaService)CamelContextHelper.mandatoryLookup((CamelContext)context, (String)this.parseString(((SagaDefinition)this.definition).getSagaServiceRef()), CamelSagaService.class);
        }
        sagaService = (CamelSagaService)context.hasService(CamelSagaService.class);
        if (sagaService != null) {
            return sagaService;
        }
        sagaService = (CamelSagaService)CamelContextHelper.findByType((CamelContext)context, CamelSagaService.class);
        if (sagaService != null) {
            return sagaService;
        }
        throw new RuntimeCamelException("Cannot find a CamelSagaService");
    }
}

