/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;

public class InterceptReifier<T extends InterceptDefinition>
extends ProcessorReifier<T> {
    public InterceptReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (InterceptDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        final Processor output = this.createChildProcessor(true);
        this.routeContext.getInterceptStrategies().add(new InterceptStrategy(){
            private Processor interceptedTarget;

            public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) throws Exception {
                this.interceptedTarget = target;
                ((InterceptDefinition)InterceptReifier.this.definition).getIntercepted().add(this.interceptedTarget);
                if (this.interceptedTarget != null) {
                    return Pipeline.newInstance((CamelContext)context, (Processor[])new Processor[]{output, this.interceptedTarget});
                }
                return output;
            }

            public String toString() {
                return "intercept[" + (this.interceptedTarget != null ? this.interceptedTarget : output) + "]";
            }
        });
        ((RouteDefinition)this.routeContext.getRoute()).getOutputs().remove(this.definition);
        return null;
    }
}

