/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlTransient
public abstract class ExpressionNode
extends ProcessorDefinition<ExpressionNode> {
    @XmlElementRef
    private ExpressionDefinition expression;

    public ExpressionNode() {
    }

    public ExpressionNode(ExpressionDefinition expression) {
        this.expression = expression;
    }

    public ExpressionNode(Expression expression) {
        if (expression != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
        }
    }

    public ExpressionNode(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(predicate));
        }
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.setExpression(new ExpressionDefinition(expression));
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public String getLabel() {
        if (this.getExpression() == null) {
            return "";
        }
        return this.getExpression().getLabel();
    }

    @Override
    public void configureChild(ProcessorDefinition<?> output) {
        this.preCreateProcessor();
    }

    @Override
    public void preCreateProcessor() {
        ExpressionFactory model;
        ExpressionClause clause;
        ExpressionDefinition exp = this.getExpression();
        if (this.getExpression() != null && this.getExpression().getExpressionValue() != null) {
            exp = this.getExpression().getExpressionValue();
        }
        if (exp instanceof ExpressionClause && (clause = (ExpressionClause)((Object)exp)).getExpressionType() != null && (model = clause.getExpressionType()) instanceof ExpressionDefinition) {
            this.setExpression((ExpressionDefinition)model);
        }
        if (this.getExpression() != null && this.getExpression().getExpression() == null) {
            if (this.getExpression().getPredicate() != null) {
                this.getExpression().setExpression(this.getExpression().getPredicate().toString());
            } else if (this.getExpression().getExpressionValue() != null) {
                this.getExpression().setExpression(this.getExpression().getExpressionValue().toString());
            }
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return Collections.emptyList();
    }

    @Override
    public ExpressionNode id(String id) {
        if (!(this instanceof OutputNode)) {
            this.getParent().id(id);
            return this;
        }
        return (ExpressionNode)super.id(id);
    }
}

