/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ModelToXMLDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelToXMLDumperResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(ModelToXMLDumperResolver.class);
    private FactoryFinder factoryFinder;

    public ModelToXMLDumper resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("modelxml-dumper", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found ModelToXMLDumper: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "modelxml-dumper"});
            }
            if (ModelToXMLDumper.class.isAssignableFrom(type)) {
                ModelToXMLDumper answer = (ModelToXMLDumper)context.getInjector().newInstance(type, false);
                LOG.info("Detected and using ModelToXMLDumper: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a ModelToXMLDumper implementation. Found: " + type.getName());
        }
        throw new RuntimeCamelException("Cannot find XML routes dumper in classpath. Add camel-xml-jaxb to the classpath.");
    }

    private Class<?> findFactory(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }
}

