/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.BatchChangeSetPart;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;
import org.apache.olingo.server.core.deserializer.batch.BatchPart;
import org.apache.olingo.server.core.deserializer.batch.BatchQueryOperation;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.HeaderField;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class BatchBodyPart
implements BatchPart {
    private final String boundary;
    private final boolean isStrict;
    private final List<Line> remainingMessage = new LinkedList<Line>();
    private Header headers;
    private boolean isChangeSet;
    private List<BatchQueryOperation> requests;

    public BatchBodyPart(List<Line> message, String boundary, boolean isStrict) {
        this.boundary = boundary;
        this.isStrict = isStrict;
        this.remainingMessage.addAll(message);
    }

    public BatchBodyPart parse() throws BatchDeserializerException {
        this.headers = BatchParserCommon.consumeHeaders(this.remainingMessage);
        BatchParserCommon.consumeBlankLine(this.remainingMessage, this.isStrict);
        this.isChangeSet = this.isChangeSet(this.headers);
        this.requests = this.consumeRequest(this.remainingMessage);
        return this;
    }

    private boolean isChangeSet(Header headers) throws BatchDeserializerException {
        List<String> contentTypes = headers.getHeaders("Content-Type");
        if (contentTypes.isEmpty()) {
            throw new BatchDeserializerException("Missing content type", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_TYPE, new String[]{Integer.toString(headers.getLineNumber())});
        }
        boolean changeSet = false;
        for (String contentType : contentTypes) {
            if (!this.isContentTypeMultiPartMixed(contentType)) continue;
            changeSet = true;
        }
        return changeSet;
    }

    private List<BatchQueryOperation> consumeRequest(List<Line> remainingMessage) throws BatchDeserializerException {
        return this.isChangeSet ? this.consumeChangeSet(remainingMessage) : this.consumeQueryOperation(remainingMessage);
    }

    private List<BatchQueryOperation> consumeChangeSet(List<Line> remainingMessage) throws BatchDeserializerException {
        List<List<Line>> changeRequests = this.splitChangeSet(remainingMessage);
        LinkedList<BatchQueryOperation> requestList = new LinkedList<BatchQueryOperation>();
        for (List<Line> changeRequest : changeRequests) {
            requestList.add(new BatchChangeSetPart(changeRequest, this.isStrict).parse());
        }
        return requestList;
    }

    private List<List<Line>> splitChangeSet(List<Line> remainingMessage) throws BatchDeserializerException {
        HeaderField contentTypeField = this.headers.getHeaderField("Content-Type");
        String changeSetBoundary = BatchParserCommon.getBoundary(contentTypeField.getValue(), contentTypeField.getLineNumber());
        this.validateChangeSetBoundary(changeSetBoundary, this.headers);
        return BatchParserCommon.splitMessageByBoundary(remainingMessage, changeSetBoundary);
    }

    private void validateChangeSetBoundary(String changeSetBoundary, Header header) throws BatchDeserializerException {
        if (changeSetBoundary.equals(this.boundary)) {
            throw new BatchDeserializerException("Change set boundary is equals to batch request boundary", (ODataLibraryException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_BOUNDARY, new String[]{Integer.toString(header.getHeaderField("Content-Type").getLineNumber())});
        }
    }

    private List<BatchQueryOperation> consumeQueryOperation(List<Line> remainingMessage) throws BatchDeserializerException {
        LinkedList<BatchQueryOperation> requestList = new LinkedList<BatchQueryOperation>();
        requestList.add(new BatchQueryOperation(remainingMessage, this.isStrict).parse());
        return requestList;
    }

    private boolean isContentTypeMultiPartMixed(String contentType) {
        try {
            BatchParserCommon.parseContentType(contentType, ContentType.MULTIPART_MIXED, 0);
            return true;
        }
        catch (BatchDeserializerException e) {
            return false;
        }
    }

    @Override
    public Header getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean isChangeSet() {
        return this.isChangeSet;
    }

    public List<BatchQueryOperation> getRequests() {
        return this.requests;
    }
}

