/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.support.OrderedComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesConfigurer.class);
    private final RoutesCollector routesCollector;
    private final List<RoutesBuilder> routesBuilders;
    private boolean addRestsToRoutes = true;

    public RoutesConfigurer(RoutesCollector routesCollector) {
        this(routesCollector, new ArrayList<RoutesBuilder>());
    }

    public RoutesConfigurer(RoutesCollector routesCollector, List<RoutesBuilder> routesBuilders) {
        this.routesCollector = routesCollector;
        this.routesBuilders = routesBuilders;
    }

    public void setAddRestsToRoutes(boolean addRestsToRoutes) {
        this.addRestsToRoutes = addRestsToRoutes;
    }

    public void configureRoutes(CamelContext camelContext, DefaultConfigurationProperties config) {
        if (config.isRoutesCollectorEnabled()) {
            try {
                boolean scanRests;
                boolean scanTemplates;
                boolean scan;
                LOG.debug("RoutesCollectorEnabled: {}", (Object)this.routesCollector);
                List<RoutesBuilder> routes = this.routesCollector.collectRoutesFromRegistry(camelContext, config.getJavaRoutesExcludePattern(), config.getJavaRoutesIncludePattern());
                this.routesBuilders.addAll(routes);
                this.routesBuilders.sort((Comparator<RoutesBuilder>)OrderedComparator.get());
                for (RoutesBuilder builder : this.routesBuilders) {
                    LOG.debug("Adding routes into CamelContext from RoutesBuilder: {}", (Object)builder);
                    camelContext.addRoutes(builder);
                }
                boolean bl = scan = !config.getXmlRoutes().equals("false");
                if (scan) {
                    List<RoutesDefinition> defs = this.routesCollector.collectXmlRoutesFromDirectory(camelContext, config.getXmlRoutes());
                    for (RoutesDefinition routesDefinition : defs) {
                        LOG.debug("Adding routes into CamelContext from XML files: {}", (Object)config.getXmlRoutes());
                        ((Model)camelContext.getExtension(Model.class)).addRouteDefinitions((Collection)routesDefinition.getRoutes());
                    }
                }
                boolean bl2 = scanTemplates = !config.getXmlRouteTemplates().equals("false");
                if (scanTemplates) {
                    List<RouteTemplatesDefinition> defs = this.routesCollector.collectXmlRouteTemplatesFromDirectory(camelContext, config.getXmlRouteTemplates());
                    for (RouteTemplatesDefinition def : defs) {
                        LOG.debug("Adding route templates into CamelContext from XML files: {}", (Object)config.getXmlRouteTemplates());
                        ((Model)camelContext.getExtension(Model.class)).addRouteTemplateDefinitions((Collection)def.getRouteTemplates());
                    }
                }
                boolean bl3 = scanRests = !config.getXmlRests().equals("false");
                if (scanRests) {
                    List<RestsDefinition> list = this.routesCollector.collectXmlRestsFromDirectory(camelContext, config.getXmlRests());
                    for (RestsDefinition def : list) {
                        LOG.debug("Adding rests into CamelContext from XML files: {}", (Object)config.getXmlRests());
                        ((Model)camelContext.getExtension(Model.class)).addRestDefinitions((Collection)def.getRests(), this.addRestsToRoutes);
                    }
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
    }
}

