/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.math.BigInteger;
import java.util.Iterator;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class ObjectConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ObjectConverterLoader.addTypeConverter(registry, Boolean.TYPE, Object.class, false, (type, exchange, value) -> ObjectConverter.toBool(value));
        ObjectConverterLoader.addTypeConverter(registry, Character.TYPE, String.class, false, (type, exchange, value) -> Character.valueOf(ObjectConverter.toChar((String)value)));
        ObjectConverterLoader.addTypeConverter(registry, char[].class, String.class, false, (type, exchange, value) -> ObjectConverter.toCharArray((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Boolean.class, Object.class, false, (type, exchange, value) -> ObjectConverter.toBoolean(value));
        ObjectConverterLoader.addTypeConverter(registry, Boolean.class, String.class, false, (type, exchange, value) -> ObjectConverter.toBoolean((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Byte.class, Number.class, true, (type, exchange, value) -> ObjectConverter.toByte((Number)value));
        ObjectConverterLoader.addTypeConverter(registry, Byte.class, String.class, false, (type, exchange, value) -> ObjectConverter.toByte((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Character.class, String.class, false, (type, exchange, value) -> ObjectConverter.toCharacter((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Class.class, String.class, false, (type, exchange, value) -> ObjectConverter.toClass((String)value, exchange));
        ObjectConverterLoader.addTypeConverter(registry, Double.class, Number.class, false, (type, exchange, value) -> ObjectConverter.toDouble((Number)value));
        ObjectConverterLoader.addTypeConverter(registry, Double.class, String.class, false, (type, exchange, value) -> ObjectConverter.toDouble((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Float.class, Number.class, false, (type, exchange, value) -> ObjectConverter.toFloat((Number)value));
        ObjectConverterLoader.addTypeConverter(registry, Float.class, String.class, false, (type, exchange, value) -> ObjectConverter.toFloat((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Integer.class, Number.class, true, (type, exchange, value) -> ObjectConverter.toInteger((Number)value));
        ObjectConverterLoader.addTypeConverter(registry, Integer.class, String.class, false, (type, exchange, value) -> ObjectConverter.toInteger((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Iterable.class, Object.class, false, (type, exchange, value) -> ObjectConverter.iterable(value));
        ObjectConverterLoader.addTypeConverter(registry, Long.class, Number.class, true, (type, exchange, value) -> ObjectConverter.toLong((Number)value));
        ObjectConverterLoader.addTypeConverter(registry, Long.class, String.class, false, (type, exchange, value) -> ObjectConverter.toLong((String)value));
        ObjectConverterLoader.addTypeConverter(registry, Short.class, Number.class, true, (type, exchange, value) -> ObjectConverter.toShort((Number)value));
        ObjectConverterLoader.addTypeConverter(registry, Short.class, String.class, false, (type, exchange, value) -> ObjectConverter.toShort((String)value));
        ObjectConverterLoader.addTypeConverter(registry, String.class, char[].class, false, (type, exchange, value) -> ObjectConverter.fromCharArray((char[])value));
        ObjectConverterLoader.addTypeConverter(registry, String.class, Boolean.class, false, (type, exchange, value) -> ObjectConverter.toString((Boolean)value));
        ObjectConverterLoader.addTypeConverter(registry, String.class, Integer.class, false, (type, exchange, value) -> ObjectConverter.toString((Integer)value));
        ObjectConverterLoader.addTypeConverter(registry, String.class, Long.class, false, (type, exchange, value) -> ObjectConverter.toString((Long)value));
        ObjectConverterLoader.addTypeConverter(registry, String.class, StringBuffer.class, false, (type, exchange, value) -> ObjectConverter.toString((StringBuffer)value));
        ObjectConverterLoader.addTypeConverter(registry, String.class, StringBuilder.class, false, (type, exchange, value) -> ObjectConverter.toString((StringBuilder)value));
        ObjectConverterLoader.addTypeConverter(registry, BigInteger.class, Object.class, true, (type, exchange, value) -> ObjectConverter.toBigInteger(value));
        ObjectConverterLoader.addTypeConverter(registry, Iterator.class, Object.class, false, (type, exchange, value) -> ObjectConverter.iterator(value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

