/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.handler;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.oaipmh.component.OAIPMHConsumer;
import org.apache.camel.oaipmh.model.OAIPMHResponse;
import org.apache.camel.spi.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandler.class);
    protected final Endpoint endpoint;
    protected final Processor processor;
    protected final ExceptionHandler exceptionHandler;

    public AbstractHandler(OAIPMHConsumer consumer) {
        this.endpoint = consumer.getEndpoint();
        this.processor = consumer.getAsyncProcessor();
        this.exceptionHandler = consumer.getExceptionHandler();
    }

    protected void send(OAIPMHResponse message) {
        Exchange exchange = this.endpoint.createExchange();
        String xml = message.getRawResponse();
        exchange.getIn().setBody((Object)xml);
        try {
            LOG.trace("sending exchange: {}", (Object)exchange);
            this.processor.process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error sending exchange: " + exchange, (Throwable)e);
        }
        finally {
            if (exchange.getException() != null) {
                this.exceptionHandler.handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

