/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nsq;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.nsq.NsqConfiguration;
import org.apache.camel.component.nsq.NsqEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="nsq")
public class NsqComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata
    private String servers;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        NsqConfiguration configuration = new NsqConfiguration();
        configuration.setServers(this.servers);
        configuration.setTopic(remaining);
        if (ObjectHelper.isEmpty((Object)remaining)) {
            throw new IllegalArgumentException("Topic must be configured");
        }
        NsqEndpoint endpoint = new NsqEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

