/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class NSQCommand {
    private String line;
    private List<byte[]> data = new ArrayList<byte[]>();
    public static final Charset ASCII = Charset.forName("ascii");

    private NSQCommand() {
    }

    public void addBytes(byte[] bytes) {
        this.data.add(bytes);
    }

    public String getLine() {
        return this.line;
    }

    public void setLine(String line) {
        if (!line.endsWith("\n")) {
            line = line + "\n";
        }
        this.line = line;
    }

    public List<byte[]> getData() {
        return this.data;
    }

    public void setData(List<byte[]> data) {
        this.data = data;
    }

    public String toString() {
        return this.getLine().trim();
    }

    public static NSQCommand identify(byte[] body) {
        return NSQCommand.instance("IDENTIFY", body);
    }

    public static NSQCommand touch(byte[] messageID) {
        return NSQCommand.instance("TOUCH " + new String(messageID, ASCII));
    }

    public static NSQCommand finish(byte[] messageID) {
        return NSQCommand.instance("FIN " + new String(messageID, ASCII));
    }

    public static NSQCommand subscribe(String topic, String channel) {
        return NSQCommand.instance("SUB " + topic + " " + channel);
    }

    public static NSQCommand startClose() {
        return NSQCommand.instance("CLS");
    }

    public static NSQCommand requeue(byte[] messageID, int timeoutMillis) {
        return NSQCommand.instance("REQ " + new String(messageID, ASCII) + " " + timeoutMillis);
    }

    public static NSQCommand nop() {
        return NSQCommand.instance("NOP");
    }

    public static NSQCommand ready(int rdy) {
        return NSQCommand.instance("RDY " + rdy);
    }

    public static NSQCommand publish(String topic, byte[] message) {
        return NSQCommand.instance("PUB " + topic, message);
    }

    public static NSQCommand multiPublish(String topic, List<byte[]> bodies) {
        NSQCommand cmd = NSQCommand.instance("MPUB " + topic);
        cmd.setData(bodies);
        return cmd;
    }

    private static NSQCommand instance(String line) {
        NSQCommand n = new NSQCommand();
        n.setLine(line);
        return n;
    }

    private static NSQCommand instance(String line, byte[] bytes) {
        NSQCommand n = NSQCommand.instance(line);
        n.addBytes(bytes);
        return n;
    }
}

