/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.transforms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldsToHeadersTransform<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldsToHeadersTransform.class);
    private static final String PURPOSE = "fields extraction to headers";
    private static final String FIELDS_CONFIG = "fields";
    private static final String HEADERS_CONFIG = "headers";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("fields", ConfigDef.Type.LIST, new ArrayList(), ConfigDef.Importance.MEDIUM, "Fields names to extract and set to headers").define("headers", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.MEDIUM, "Headers names to set with extracted fields");
    private List<String> fields;
    private List<String> headers;

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    public R apply(R r) {
        RecordValue value = this.createRecordValue(r);
        if (this.fields.isEmpty()) {
            Schema currentSchema = value.getFieldSchema("");
            Object currentValue = value.getFieldValue("");
            r.headers().add(this.headers.get(0), currentValue, currentSchema);
        } else {
            for (int i = 0; i < this.fields.size(); ++i) {
                Schema currentSchema = value.getFieldSchema(this.fields.get(i));
                Object currentValue = value.getFieldValue(this.fields.get(i));
                r.headers().add(this.headers.get(i), currentValue, currentSchema);
            }
        }
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
        Map parsedConfig = CONFIG_DEF.parse(map);
        this.fields = parsedConfig.getOrDefault(FIELDS_CONFIG, new ArrayList());
        this.headers = parsedConfig.getOrDefault(HEADERS_CONFIG, new ArrayList());
        this.validateConfig();
    }

    private void validateConfig() {
        boolean validFields = this.fields.stream().allMatch(nef -> nef != null);
        boolean validHeaders = this.headers.stream().allMatch(nef -> nef != null && !nef.trim().isEmpty());
        if (!validFields || !validHeaders) {
            throw new IllegalArgumentException("fields configuration property cannot be null (can be an empty string if you want the whole value/key), headers configuration property cannot be null or contain empty elements.");
        }
        if (this.fields.size() != 0 && this.fields.size() > this.headers.size()) {
            String fieldsWithoutCorrespondingHeaders = this.fields.subList(this.headers.size(), this.fields.size()).stream().collect(Collectors.joining(","));
            throw new IllegalArgumentException("There is no corresponding header(s) configured for the following field(s): " + fieldsWithoutCorrespondingHeaders);
        }
        if (this.fields.size() != 0 && this.headers.size() > this.fields.size()) {
            String headersWithoutCorrespondingFields = this.headers.subList(this.fields.size(), this.headers.size()).stream().collect(Collectors.joining(","));
            LOG.warn("There is no corresponding header(s) for the following field(s): {} ", (Object)headersWithoutCorrespondingFields);
        }
        if (this.fields.size() == 0 && this.headers.size() > 1) {
            LOG.warn("Fields are empty and there are more than 1 header it means whole value/key will put in the first header of this list: {} ", (Object)this.headers.stream().collect(Collectors.joining(",")));
        }
    }

    private RecordValue createRecordValue(R r) {
        Schema schema = this.operatingSchema(r);
        if (this.fields.isEmpty()) {
            return new WholeRecordValue(this.operatingValue(r), schema);
        }
        if (schema == null) {
            return new MapRecordValue(Requirements.requireMapOrNull((Object)this.operatingValue(r), (String)PURPOSE));
        }
        return new StructRecordValue(Requirements.requireStructOrNull((Object)this.operatingValue(r), (String)PURPOSE), schema);
    }

    public class StructRecordValue
    implements RecordValue {
        private Struct struct;
        private Schema schema;

        public StructRecordValue(Struct struct, Schema schema) {
            this.struct = struct;
            this.schema = schema;
        }

        @Override
        public Object getFieldValue(String fieldName) {
            return this.struct.get(fieldName);
        }

        @Override
        public Schema getFieldSchema(String fieldName) {
            Field field = this.schema.field(fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Unknown field: " + fieldName);
            }
            return field.schema();
        }
    }

    public class MapRecordValue
    implements RecordValue {
        private Map<String, Object> map;

        public MapRecordValue(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public Object getFieldValue(String fieldName) {
            return this.map == null ? null : this.map.get(fieldName);
        }

        @Override
        public Schema getFieldSchema(String fieldName) {
            return null;
        }
    }

    public class WholeRecordValue
    implements RecordValue {
        private Object value;
        private Schema schema;

        public WholeRecordValue(Object value, Schema schema) {
            this.value = value;
            this.schema = schema;
        }

        @Override
        public Object getFieldValue(String fieldName) {
            return this.value;
        }

        @Override
        public Schema getFieldSchema(String fieldName) {
            return this.schema;
        }
    }

    public static interface RecordValue {
        public Object getFieldValue(String var1);

        public Schema getFieldSchema(String var1);
    }

    public static class Value<R extends ConnectRecord<R>>
    extends FieldsToHeadersTransform<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.value();
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends FieldsToHeadersTransform<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.key();
        }
    }
}

